/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PredefinedScalingMetricType {
    ASG_AVERAGE_CPU_UTILIZATION("ASGAverageCPUUtilization"),
    ASG_AVERAGE_NETWORK_IN("ASGAverageNetworkIn"),
    ASG_AVERAGE_NETWORK_OUT("ASGAverageNetworkOut"),
    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PredefinedScalingMetricType> VALUE_MAP;
    private final String value;

    private PredefinedScalingMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PredefinedScalingMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PredefinedScalingMetricType> knownValues() {
        EnumSet<PredefinedScalingMetricType> knownValues = EnumSet.allOf(PredefinedScalingMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PredefinedScalingMetricType.class, PredefinedScalingMetricType::toString);
    }
}

