/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RefreshStrategy {
    ROLLING("Rolling"),
    REPLACE_ROOT_VOLUME("ReplaceRootVolume"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RefreshStrategy> VALUE_MAP;
    private final String value;

    private RefreshStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RefreshStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RefreshStrategy> knownValues() {
        EnumSet<RefreshStrategy> knownValues = EnumSet.allOf(RefreshStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RefreshStrategy.class, RefreshStrategy::toString);
    }
}

