/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RetryStrategy {
    RETRY_WITH_GROUP_CONFIGURATION("retry-with-group-configuration"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RetryStrategy> VALUE_MAP;
    private final String value;

    private RetryStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RetryStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RetryStrategy> knownValues() {
        EnumSet<RetryStrategy> knownValues = EnumSet.allOf(RetryStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RetryStrategy.class, RetryStrategy::toString);
    }
}

