/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.ConfirmationState;
import software.amazon.awssdk.services.bedrockagentruntime.model.ContentBody;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseBodyCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionResult> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroup").getter(FunctionResult.getter(FunctionResult::actionGroup)).setter(FunctionResult.setter(Builder::actionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(FunctionResult.getter(FunctionResult::agentId)).setter(FunctionResult.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> CONFIRMATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationState").getter(FunctionResult.getter(FunctionResult::confirmationStateAsString)).setter(FunctionResult.setter(Builder::confirmationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationState").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(FunctionResult.getter(FunctionResult::function)).setter(FunctionResult.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final SdkField<Map<String, ContentBody>> RESPONSE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseBody").getter(FunctionResult.getter(FunctionResult::responseBody)).setter(FunctionResult.setter(Builder::responseBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseBody").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseState").getter(FunctionResult.getter(FunctionResult::responseStateAsString)).setter(FunctionResult.setter(Builder::responseState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD, AGENT_ID_FIELD, CONFIRMATION_STATE_FIELD, FUNCTION_FIELD, RESPONSE_BODY_FIELD, RESPONSE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionGroup;
    private final String agentId;
    private final String confirmationState;
    private final String function;
    private final Map<String, ContentBody> responseBody;
    private final String responseState;

    private FunctionResult(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.agentId = builder.agentId;
        this.confirmationState = builder.confirmationState;
        this.function = builder.function;
        this.responseBody = builder.responseBody;
        this.responseState = builder.responseState;
    }

    public final String actionGroup() {
        return this.actionGroup;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final ConfirmationState confirmationState() {
        return ConfirmationState.fromValue(this.confirmationState);
    }

    public final String confirmationStateAsString() {
        return this.confirmationState;
    }

    public final String function() {
        return this.function;
    }

    public final boolean hasResponseBody() {
        return this.responseBody != null && !(this.responseBody instanceof SdkAutoConstructMap);
    }

    public final Map<String, ContentBody> responseBody() {
        return this.responseBody;
    }

    public final ResponseState responseState() {
        return ResponseState.fromValue(this.responseState);
    }

    public final String responseStateAsString() {
        return this.responseState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseBody() ? this.responseBody() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionResult)) {
            return false;
        }
        FunctionResult other = (FunctionResult)obj;
        return Objects.equals(this.actionGroup(), other.actionGroup()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.confirmationStateAsString(), other.confirmationStateAsString()) && Objects.equals(this.function(), other.function()) && this.hasResponseBody() == other.hasResponseBody() && Objects.equals(this.responseBody(), other.responseBody()) && Objects.equals(this.responseStateAsString(), other.responseStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionResult").add("ActionGroup", (Object)this.actionGroup()).add("AgentId", (Object)this.agentId()).add("ConfirmationState", (Object)this.confirmationStateAsString()).add("Function", (Object)this.function()).add("ResponseBody", this.hasResponseBody() ? this.responseBody() : null).add("ResponseState", (Object)this.responseStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroup": {
                return Optional.ofNullable(clazz.cast(this.actionGroup()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "confirmationState": {
                return Optional.ofNullable(clazz.cast(this.confirmationStateAsString()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "responseBody": {
                return Optional.ofNullable(clazz.cast(this.responseBody()));
            }
            case "responseState": {
                return Optional.ofNullable(clazz.cast(this.responseStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroup", ACTION_GROUP_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("confirmationState", CONFIRMATION_STATE_FIELD);
        map.put("function", FUNCTION_FIELD);
        map.put("responseBody", RESPONSE_BODY_FIELD);
        map.put("responseState", RESPONSE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionResult, T> g) {
        return obj -> g.apply((FunctionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroup;
        private String agentId;
        private String confirmationState;
        private String function;
        private Map<String, ContentBody> responseBody = DefaultSdkAutoConstructMap.getInstance();
        private String responseState;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionResult model) {
            this.actionGroup(model.actionGroup);
            this.agentId(model.agentId);
            this.confirmationState(model.confirmationState);
            this.function(model.function);
            this.responseBody(model.responseBody);
            this.responseState(model.responseState);
        }

        public final String getActionGroup() {
            return this.actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getConfirmationState() {
            return this.confirmationState;
        }

        public final void setConfirmationState(String confirmationState) {
            this.confirmationState = confirmationState;
        }

        @Override
        public final Builder confirmationState(String confirmationState) {
            this.confirmationState = confirmationState;
            return this;
        }

        @Override
        public final Builder confirmationState(ConfirmationState confirmationState) {
            this.confirmationState(confirmationState == null ? null : confirmationState.toString());
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final Map<String, ContentBody.Builder> getResponseBody() {
            Map<String, ContentBody.Builder> result = ResponseBodyCopier.copyToBuilder(this.responseBody);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponseBody(Map<String, ContentBody.BuilderImpl> responseBody) {
            this.responseBody = ResponseBodyCopier.copyFromBuilder(responseBody);
        }

        @Override
        public final Builder responseBody(Map<String, ContentBody> responseBody) {
            this.responseBody = ResponseBodyCopier.copy(responseBody);
            return this;
        }

        public final String getResponseState() {
            return this.responseState;
        }

        public final void setResponseState(String responseState) {
            this.responseState = responseState;
        }

        @Override
        public final Builder responseState(String responseState) {
            this.responseState = responseState;
            return this;
        }

        @Override
        public final Builder responseState(ResponseState responseState) {
            this.responseState(responseState == null ? null : responseState.toString());
            return this;
        }

        public FunctionResult build() {
            return new FunctionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionResult> {
        public Builder actionGroup(String var1);

        public Builder agentId(String var1);

        public Builder confirmationState(String var1);

        public Builder confirmationState(ConfirmationState var1);

        public Builder function(String var1);

        public Builder responseBody(Map<String, ContentBody> var1);

        public Builder responseState(String var1);

        public Builder responseState(ResponseState var1);
    }
}

