/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeErrorCode {
    VALIDATION("VALIDATION"),
    DEPENDENCY_FAILED("DEPENDENCY_FAILED"),
    BAD_GATEWAY("BAD_GATEWAY"),
    INTERNAL_SERVER("INTERNAL_SERVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeErrorCode> VALUE_MAP;
    private final String value;

    private NodeErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeErrorCode> knownValues() {
        EnumSet<NodeErrorCode> knownValues = EnumSet.allOf(NodeErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeErrorCode.class, NodeErrorCode::toString);
    }
}

