/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeType {
    FLOW_INPUT_NODE("FlowInputNode"),
    FLOW_OUTPUT_NODE("FlowOutputNode"),
    LAMBDA_FUNCTION_NODE("LambdaFunctionNode"),
    KNOWLEDGE_BASE_NODE("KnowledgeBaseNode"),
    PROMPT_NODE("PromptNode"),
    CONDITION_NODE("ConditionNode"),
    LEX_NODE("LexNode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeType> VALUE_MAP;
    private final String value;

    private NodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeType> knownValues() {
        EnumSet<NodeType> knownValues = EnumSet.allOf(NodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeType.class, NodeType::toString);
    }
}

