/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.ModelInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.Observation;
import software.amazon.awssdk.services.bedrockagentruntime.model.OrchestrationModelInvocationOutput;
import software.amazon.awssdk.services.bedrockagentruntime.model.Rationale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrchestrationTrace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrchestrationTrace> {
    private static final SdkField<InvocationInput> INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invocationInput").getter(OrchestrationTrace.getter(OrchestrationTrace::invocationInput)).setter(OrchestrationTrace.setter(Builder::invocationInput)).constructor(InvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInput").build()}).build();
    private static final SdkField<ModelInvocationInput> MODEL_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelInvocationInput").getter(OrchestrationTrace.getter(OrchestrationTrace::modelInvocationInput)).setter(OrchestrationTrace.setter(Builder::modelInvocationInput)).constructor(ModelInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationInput").build()}).build();
    private static final SdkField<OrchestrationModelInvocationOutput> MODEL_INVOCATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelInvocationOutput").getter(OrchestrationTrace.getter(OrchestrationTrace::modelInvocationOutput)).setter(OrchestrationTrace.setter(Builder::modelInvocationOutput)).constructor(OrchestrationModelInvocationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationOutput").build()}).build();
    private static final SdkField<Observation> OBSERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("observation").getter(OrchestrationTrace.getter(OrchestrationTrace::observation)).setter(OrchestrationTrace.setter(Builder::observation)).constructor(Observation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observation").build()}).build();
    private static final SdkField<Rationale> RATIONALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rationale").getter(OrchestrationTrace.getter(OrchestrationTrace::rationale)).setter(OrchestrationTrace.setter(Builder::rationale)).constructor(Rationale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rationale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_INPUT_FIELD, MODEL_INVOCATION_INPUT_FIELD, MODEL_INVOCATION_OUTPUT_FIELD, OBSERVATION_FIELD, RATIONALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrchestrationTrace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InvocationInput invocationInput;
    private final ModelInvocationInput modelInvocationInput;
    private final OrchestrationModelInvocationOutput modelInvocationOutput;
    private final Observation observation;
    private final Rationale rationale;
    private final Type type;

    private OrchestrationTrace(BuilderImpl builder) {
        this.invocationInput = builder.invocationInput;
        this.modelInvocationInput = builder.modelInvocationInput;
        this.modelInvocationOutput = builder.modelInvocationOutput;
        this.observation = builder.observation;
        this.rationale = builder.rationale;
        this.type = builder.type;
    }

    public final InvocationInput invocationInput() {
        return this.invocationInput;
    }

    public final ModelInvocationInput modelInvocationInput() {
        return this.modelInvocationInput;
    }

    public final OrchestrationModelInvocationOutput modelInvocationOutput() {
        return this.modelInvocationOutput;
    }

    public final Observation observation() {
        return this.observation;
    }

    public final Rationale rationale() {
        return this.rationale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.observation());
        hashCode = 31 * hashCode + Objects.hashCode(this.rationale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationTrace)) {
            return false;
        }
        OrchestrationTrace other = (OrchestrationTrace)obj;
        return Objects.equals(this.invocationInput(), other.invocationInput()) && Objects.equals(this.modelInvocationInput(), other.modelInvocationInput()) && Objects.equals(this.modelInvocationOutput(), other.modelInvocationOutput()) && Objects.equals(this.observation(), other.observation()) && Objects.equals(this.rationale(), other.rationale());
    }

    public final String toString() {
        return ToString.builder((String)"OrchestrationTrace").add("InvocationInput", (Object)(this.invocationInput() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelInvocationInput", (Object)(this.modelInvocationInput() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelInvocationOutput", (Object)(this.modelInvocationOutput() == null ? null : "*** Sensitive Data Redacted ***")).add("Observation", (Object)(this.observation() == null ? null : "*** Sensitive Data Redacted ***")).add("Rationale", (Object)(this.rationale() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationInput": {
                return Optional.ofNullable(clazz.cast(this.invocationInput()));
            }
            case "modelInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.modelInvocationInput()));
            }
            case "modelInvocationOutput": {
                return Optional.ofNullable(clazz.cast(this.modelInvocationOutput()));
            }
            case "observation": {
                return Optional.ofNullable(clazz.cast(this.observation()));
            }
            case "rationale": {
                return Optional.ofNullable(clazz.cast(this.rationale()));
            }
        }
        return Optional.empty();
    }

    public static OrchestrationTrace fromInvocationInput(InvocationInput invocationInput) {
        return (OrchestrationTrace)OrchestrationTrace.builder().invocationInput(invocationInput).build();
    }

    public static OrchestrationTrace fromInvocationInput(Consumer<InvocationInput.Builder> invocationInput) {
        InvocationInput.Builder builder = InvocationInput.builder();
        invocationInput.accept(builder);
        return OrchestrationTrace.fromInvocationInput((InvocationInput)builder.build());
    }

    public static OrchestrationTrace fromModelInvocationInput(ModelInvocationInput modelInvocationInput) {
        return (OrchestrationTrace)OrchestrationTrace.builder().modelInvocationInput(modelInvocationInput).build();
    }

    public static OrchestrationTrace fromModelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
        ModelInvocationInput.Builder builder = ModelInvocationInput.builder();
        modelInvocationInput.accept(builder);
        return OrchestrationTrace.fromModelInvocationInput((ModelInvocationInput)builder.build());
    }

    public static OrchestrationTrace fromModelInvocationOutput(OrchestrationModelInvocationOutput modelInvocationOutput) {
        return (OrchestrationTrace)OrchestrationTrace.builder().modelInvocationOutput(modelInvocationOutput).build();
    }

    public static OrchestrationTrace fromModelInvocationOutput(Consumer<OrchestrationModelInvocationOutput.Builder> modelInvocationOutput) {
        OrchestrationModelInvocationOutput.Builder builder = OrchestrationModelInvocationOutput.builder();
        modelInvocationOutput.accept(builder);
        return OrchestrationTrace.fromModelInvocationOutput((OrchestrationModelInvocationOutput)builder.build());
    }

    public static OrchestrationTrace fromObservation(Observation observation) {
        return (OrchestrationTrace)OrchestrationTrace.builder().observation(observation).build();
    }

    public static OrchestrationTrace fromObservation(Consumer<Observation.Builder> observation) {
        Observation.Builder builder = Observation.builder();
        observation.accept(builder);
        return OrchestrationTrace.fromObservation((Observation)builder.build());
    }

    public static OrchestrationTrace fromRationale(Rationale rationale) {
        return (OrchestrationTrace)OrchestrationTrace.builder().rationale(rationale).build();
    }

    public static OrchestrationTrace fromRationale(Consumer<Rationale.Builder> rationale) {
        Rationale.Builder builder = Rationale.builder();
        rationale.accept(builder);
        return OrchestrationTrace.fromRationale((Rationale)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invocationInput", INVOCATION_INPUT_FIELD);
        map.put("modelInvocationInput", MODEL_INVOCATION_INPUT_FIELD);
        map.put("modelInvocationOutput", MODEL_INVOCATION_OUTPUT_FIELD);
        map.put("observation", OBSERVATION_FIELD);
        map.put("rationale", RATIONALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationTrace, T> g) {
        return obj -> g.apply((OrchestrationTrace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INVOCATION_INPUT,
        MODEL_INVOCATION_INPUT,
        MODEL_INVOCATION_OUTPUT,
        OBSERVATION,
        RATIONALE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InvocationInput invocationInput;
        private ModelInvocationInput modelInvocationInput;
        private OrchestrationModelInvocationOutput modelInvocationOutput;
        private Observation observation;
        private Rationale rationale;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationTrace model) {
            this.invocationInput(model.invocationInput);
            this.modelInvocationInput(model.modelInvocationInput);
            this.modelInvocationOutput(model.modelInvocationOutput);
            this.observation(model.observation);
            this.rationale(model.rationale);
        }

        public final InvocationInput.Builder getInvocationInput() {
            return this.invocationInput != null ? this.invocationInput.toBuilder() : null;
        }

        public final void setInvocationInput(InvocationInput.BuilderImpl invocationInput) {
            InvocationInput oldValue = this.invocationInput;
            this.invocationInput = invocationInput != null ? invocationInput.build() : null;
            this.handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
        }

        @Override
        public final Builder invocationInput(InvocationInput invocationInput) {
            InvocationInput oldValue = this.invocationInput;
            this.invocationInput = invocationInput;
            this.handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
            return this;
        }

        public final ModelInvocationInput.Builder getModelInvocationInput() {
            return this.modelInvocationInput != null ? this.modelInvocationInput.toBuilder() : null;
        }

        public final void setModelInvocationInput(ModelInvocationInput.BuilderImpl modelInvocationInput) {
            ModelInvocationInput oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput != null ? modelInvocationInput.build() : null;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
        }

        @Override
        public final Builder modelInvocationInput(ModelInvocationInput modelInvocationInput) {
            ModelInvocationInput oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
            return this;
        }

        public final OrchestrationModelInvocationOutput.Builder getModelInvocationOutput() {
            return this.modelInvocationOutput != null ? this.modelInvocationOutput.toBuilder() : null;
        }

        public final void setModelInvocationOutput(OrchestrationModelInvocationOutput.BuilderImpl modelInvocationOutput) {
            OrchestrationModelInvocationOutput oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput != null ? modelInvocationOutput.build() : null;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
        }

        @Override
        public final Builder modelInvocationOutput(OrchestrationModelInvocationOutput modelInvocationOutput) {
            OrchestrationModelInvocationOutput oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput;
            this.handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
            return this;
        }

        public final Observation.Builder getObservation() {
            return this.observation != null ? this.observation.toBuilder() : null;
        }

        public final void setObservation(Observation.BuilderImpl observation) {
            Observation oldValue = this.observation;
            this.observation = observation != null ? observation.build() : null;
            this.handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
        }

        @Override
        public final Builder observation(Observation observation) {
            Observation oldValue = this.observation;
            this.observation = observation;
            this.handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
            return this;
        }

        public final Rationale.Builder getRationale() {
            return this.rationale != null ? this.rationale.toBuilder() : null;
        }

        public final void setRationale(Rationale.BuilderImpl rationale) {
            Rationale oldValue = this.rationale;
            this.rationale = rationale != null ? rationale.build() : null;
            this.handleUnionValueChange(Type.RATIONALE, oldValue, this.rationale);
        }

        @Override
        public final Builder rationale(Rationale rationale) {
            Rationale oldValue = this.rationale;
            this.rationale = rationale;
            this.handleUnionValueChange(Type.RATIONALE, oldValue, this.rationale);
            return this;
        }

        public OrchestrationTrace build() {
            return new OrchestrationTrace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrchestrationTrace> {
        public Builder invocationInput(InvocationInput var1);

        default public Builder invocationInput(Consumer<InvocationInput.Builder> invocationInput) {
            return this.invocationInput((InvocationInput)((InvocationInput.Builder)InvocationInput.builder().applyMutation(invocationInput)).build());
        }

        public Builder modelInvocationInput(ModelInvocationInput var1);

        default public Builder modelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
            return this.modelInvocationInput((ModelInvocationInput)((ModelInvocationInput.Builder)ModelInvocationInput.builder().applyMutation(modelInvocationInput)).build());
        }

        public Builder modelInvocationOutput(OrchestrationModelInvocationOutput var1);

        default public Builder modelInvocationOutput(Consumer<OrchestrationModelInvocationOutput.Builder> modelInvocationOutput) {
            return this.modelInvocationOutput((OrchestrationModelInvocationOutput)((OrchestrationModelInvocationOutput.Builder)OrchestrationModelInvocationOutput.builder().applyMutation(modelInvocationOutput)).build());
        }

        public Builder observation(Observation var1);

        default public Builder observation(Consumer<Observation.Builder> observation) {
            return this.observation((Observation)((Observation.Builder)Observation.builder().applyMutation(observation)).build());
        }

        public Builder rationale(Rationale var1);

        default public Builder rationale(Consumer<Rationale.Builder> rationale) {
            return this.rationale((Rationale)((Rationale.Builder)Rationale.builder().applyMutation(rationale)).build());
        }
    }
}

