/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billing.model.BillingViewHealthStatus;
import software.amazon.awssdk.services.billing.model.BillingViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingViewListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingViewListElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BillingViewListElement.getter(BillingViewListElement::arn)).setter(BillingViewListElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(BillingViewListElement.getter(BillingViewListElement::name)).setter(BillingViewListElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BillingViewListElement.getter(BillingViewListElement::description)).setter(BillingViewListElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(BillingViewListElement.getter(BillingViewListElement::ownerAccountId)).setter(BillingViewListElement.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccountId").getter(BillingViewListElement.getter(BillingViewListElement::sourceAccountId)).setter(BillingViewListElement.setter(Builder::sourceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()}).build();
    private static final SdkField<String> BILLING_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingViewType").getter(BillingViewListElement.getter(BillingViewListElement::billingViewTypeAsString)).setter(BillingViewListElement.setter(Builder::billingViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViewType").build()}).build();
    private static final SdkField<BillingViewHealthStatus> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthStatus").getter(BillingViewListElement.getter(BillingViewListElement::healthStatus)).setter(BillingViewListElement.setter(Builder::healthStatus)).constructor(BillingViewHealthStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, OWNER_ACCOUNT_ID_FIELD, SOURCE_ACCOUNT_ID_FIELD, BILLING_VIEW_TYPE_FIELD, HEALTH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillingViewListElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String ownerAccountId;
    private final String sourceAccountId;
    private final String billingViewType;
    private final BillingViewHealthStatus healthStatus;

    private BillingViewListElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.ownerAccountId = builder.ownerAccountId;
        this.sourceAccountId = builder.sourceAccountId;
        this.billingViewType = builder.billingViewType;
        this.healthStatus = builder.healthStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String sourceAccountId() {
        return this.sourceAccountId;
    }

    public final BillingViewType billingViewType() {
        return BillingViewType.fromValue(this.billingViewType);
    }

    public final String billingViewTypeAsString() {
        return this.billingViewType;
    }

    public final BillingViewHealthStatus healthStatus() {
        return this.healthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingViewListElement)) {
            return false;
        }
        BillingViewListElement other = (BillingViewListElement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.sourceAccountId(), other.sourceAccountId()) && Objects.equals(this.billingViewTypeAsString(), other.billingViewTypeAsString()) && Objects.equals(this.healthStatus(), other.healthStatus());
    }

    public final String toString() {
        return ToString.builder((String)"BillingViewListElement").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("OwnerAccountId", (Object)this.ownerAccountId()).add("SourceAccountId", (Object)this.sourceAccountId()).add("BillingViewType", (Object)this.billingViewTypeAsString()).add("HealthStatus", (Object)this.healthStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "sourceAccountId": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountId()));
            }
            case "billingViewType": {
                return Optional.ofNullable(clazz.cast(this.billingViewTypeAsString()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("sourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("billingViewType", BILLING_VIEW_TYPE_FIELD);
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingViewListElement, T> g) {
        return obj -> g.apply((BillingViewListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String ownerAccountId;
        private String sourceAccountId;
        private String billingViewType;
        private BillingViewHealthStatus healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingViewListElement model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.ownerAccountId(model.ownerAccountId);
            this.sourceAccountId(model.sourceAccountId);
            this.billingViewType(model.billingViewType);
            this.healthStatus(model.healthStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSourceAccountId() {
            return this.sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getBillingViewType() {
            return this.billingViewType;
        }

        public final void setBillingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
        }

        @Override
        public final Builder billingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
            return this;
        }

        @Override
        public final Builder billingViewType(BillingViewType billingViewType) {
            this.billingViewType(billingViewType == null ? null : billingViewType.toString());
            return this;
        }

        public final BillingViewHealthStatus.Builder getHealthStatus() {
            return this.healthStatus != null ? this.healthStatus.toBuilder() : null;
        }

        public final void setHealthStatus(BillingViewHealthStatus.BuilderImpl healthStatus) {
            this.healthStatus = healthStatus != null ? healthStatus.build() : null;
        }

        @Override
        public final Builder healthStatus(BillingViewHealthStatus healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public BillingViewListElement build() {
            return new BillingViewListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingViewListElement> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder ownerAccountId(String var1);

        public Builder sourceAccountId(String var1);

        public Builder billingViewType(String var1);

        public Builder billingViewType(BillingViewType var1);

        public Builder healthStatus(BillingViewHealthStatus var1);

        default public Builder healthStatus(Consumer<BillingViewHealthStatus.Builder> healthStatus) {
            return this.healthStatus((BillingViewHealthStatus)((BillingViewHealthStatus.Builder)BillingViewHealthStatus.builder().applyMutation(healthStatus)).build());
        }
    }
}

