/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billing.model.BillingRequest;
import software.amazon.awssdk.services.billing.model.BillingViewSourceViewsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateSourceViewsRequest
extends BillingRequest
implements ToCopyableBuilder<Builder, DisassociateSourceViewsRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DisassociateSourceViewsRequest.getter(DisassociateSourceViewsRequest::arn)).setter(DisassociateSourceViewsRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> SOURCE_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceViews").getter(DisassociateSourceViewsRequest.getter(DisassociateSourceViewsRequest::sourceViews)).setter(DisassociateSourceViewsRequest.setter(Builder::sourceViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SOURCE_VIEWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateSourceViewsRequest.memberNameToFieldInitializer();
    private final String arn;
    private final List<String> sourceViews;

    private DisassociateSourceViewsRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.sourceViews = builder.sourceViews;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasSourceViews() {
        return this.sourceViews != null && !(this.sourceViews instanceof SdkAutoConstructList);
    }

    public final List<String> sourceViews() {
        return this.sourceViews;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceViews() ? this.sourceViews() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSourceViewsRequest)) {
            return false;
        }
        DisassociateSourceViewsRequest other = (DisassociateSourceViewsRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasSourceViews() == other.hasSourceViews() && Objects.equals(this.sourceViews(), other.sourceViews());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateSourceViewsRequest").add("Arn", (Object)this.arn()).add("SourceViews", this.hasSourceViews() ? this.sourceViews() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "sourceViews": {
                return Optional.ofNullable(clazz.cast(this.sourceViews()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("sourceViews", SOURCE_VIEWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSourceViewsRequest, T> g) {
        return obj -> g.apply((DisassociateSourceViewsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingRequest.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> sourceViews = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSourceViewsRequest model) {
            super(model);
            this.arn(model.arn);
            this.sourceViews(model.sourceViews);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getSourceViews() {
            if (this.sourceViews instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceViews;
        }

        public final void setSourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
        }

        @Override
        public final Builder sourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceViews(String ... sourceViews) {
            this.sourceViews(Arrays.asList(sourceViews));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateSourceViewsRequest build() {
            return new DisassociateSourceViewsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BillingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateSourceViewsRequest> {
        public Builder arn(String var1);

        public Builder sourceViews(Collection<String> var1);

        public Builder sourceViews(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

