/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billing.BillingAsyncClient;
import software.amazon.awssdk.services.billing.internal.UserAgentUtils;
import software.amazon.awssdk.services.billing.model.BillingViewListElement;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;

public class ListBillingViewsPublisher
implements SdkPublisher<ListBillingViewsResponse> {
    private final BillingAsyncClient client;
    private final ListBillingViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillingViewsPublisher(BillingAsyncClient client, ListBillingViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillingViewsPublisher(BillingAsyncClient client, ListBillingViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillingViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillingViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillingViewListElement> billingViews() {
        Function<ListBillingViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingViews() != null) {
                return response.billingViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillingViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillingViewsResponseFetcher
    implements AsyncPageFetcher<ListBillingViewsResponse> {
        private ListBillingViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillingViewsResponse> nextPage(ListBillingViewsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingViewsPublisher.this.client.listBillingViews(ListBillingViewsPublisher.this.firstRequest);
            }
            return ListBillingViewsPublisher.this.client.listBillingViews((ListBillingViewsRequest)((Object)ListBillingViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

