/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DatetimeOptions;
import software.amazon.awssdk.services.databrew.model.FilterExpression;
import software.amazon.awssdk.services.databrew.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DatasetParameter.getter(DatasetParameter::name)).setter(DatasetParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DatasetParameter.getter(DatasetParameter::typeAsString)).setter(DatasetParameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<DatetimeOptions> DATETIME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatetimeOptions").getter(DatasetParameter.getter(DatasetParameter::datetimeOptions)).setter(DatasetParameter.setter(Builder::datetimeOptions)).constructor(DatetimeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatetimeOptions").build()}).build();
    private static final SdkField<Boolean> CREATE_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CreateColumn").getter(DatasetParameter.getter(DatasetParameter::createColumn)).setter(DatasetParameter.setter(Builder::createColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumn").build()}).build();
    private static final SdkField<FilterExpression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(DatasetParameter.getter(DatasetParameter::filter)).setter(DatasetParameter.setter(Builder::filter)).constructor(FilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DATETIME_OPTIONS_FIELD, CREATE_COLUMN_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final DatetimeOptions datetimeOptions;
    private final Boolean createColumn;
    private final FilterExpression filter;

    private DatasetParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.datetimeOptions = builder.datetimeOptions;
        this.createColumn = builder.createColumn;
        this.filter = builder.filter;
    }

    public final String name() {
        return this.name;
    }

    public final ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DatetimeOptions datetimeOptions() {
        return this.datetimeOptions;
    }

    public final Boolean createColumn() {
        return this.createColumn;
    }

    public final FilterExpression filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datetimeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.createColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetParameter)) {
            return false;
        }
        DatasetParameter other = (DatasetParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.datetimeOptions(), other.datetimeOptions()) && Objects.equals(this.createColumn(), other.createColumn()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetParameter").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DatetimeOptions", (Object)this.datetimeOptions()).add("CreateColumn", (Object)this.createColumn()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DatetimeOptions": {
                return Optional.ofNullable(clazz.cast(this.datetimeOptions()));
            }
            case "CreateColumn": {
                return Optional.ofNullable(clazz.cast(this.createColumn()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DatetimeOptions", DATETIME_OPTIONS_FIELD);
        map.put("CreateColumn", CREATE_COLUMN_FIELD);
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetParameter, T> g) {
        return obj -> g.apply((DatasetParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private DatetimeOptions datetimeOptions;
        private Boolean createColumn;
        private FilterExpression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetParameter model) {
            this.name(model.name);
            this.type(model.type);
            this.datetimeOptions(model.datetimeOptions);
            this.createColumn(model.createColumn);
            this.filter(model.filter);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DatetimeOptions.Builder getDatetimeOptions() {
            return this.datetimeOptions != null ? this.datetimeOptions.toBuilder() : null;
        }

        public final void setDatetimeOptions(DatetimeOptions.BuilderImpl datetimeOptions) {
            this.datetimeOptions = datetimeOptions != null ? datetimeOptions.build() : null;
        }

        @Override
        public final Builder datetimeOptions(DatetimeOptions datetimeOptions) {
            this.datetimeOptions = datetimeOptions;
            return this;
        }

        public final Boolean getCreateColumn() {
            return this.createColumn;
        }

        public final void setCreateColumn(Boolean createColumn) {
            this.createColumn = createColumn;
        }

        @Override
        public final Builder createColumn(Boolean createColumn) {
            this.createColumn = createColumn;
            return this;
        }

        public final FilterExpression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(FilterExpression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(FilterExpression filter) {
            this.filter = filter;
            return this;
        }

        public DatasetParameter build() {
            return new DatasetParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetParameter> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder datetimeOptions(DatetimeOptions var1);

        default public Builder datetimeOptions(Consumer<DatetimeOptions.Builder> datetimeOptions) {
            return this.datetimeOptions((DatetimeOptions)((DatetimeOptions.Builder)DatetimeOptions.builder().applyMutation(datetimeOptions)).build());
        }

        public Builder createColumn(Boolean var1);

        public Builder filter(FilterExpression var1);

        default public Builder filter(Consumer<FilterExpression.Builder> filter) {
            return this.filter((FilterExpression)((FilterExpression.Builder)FilterExpression.builder().applyMutation(filter)).build());
        }
    }
}

