/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.CapabilityIssue;
import software.amazon.awssdk.services.eks.model.CapabilityIssueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapabilityHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapabilityHealth> {
    private static final SdkField<List<CapabilityIssue>> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("issues").getter(CapabilityHealth.getter(CapabilityHealth::issues)).setter(CapabilityHealth.setter(Builder::issues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapabilityIssue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapabilityHealth.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CapabilityIssue> issues;

    private CapabilityHealth(BuilderImpl builder) {
        this.issues = builder.issues;
    }

    public final boolean hasIssues() {
        return this.issues != null && !(this.issues instanceof SdkAutoConstructList);
    }

    public final List<CapabilityIssue> issues() {
        return this.issues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssues() ? this.issues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityHealth)) {
            return false;
        }
        CapabilityHealth other = (CapabilityHealth)obj;
        return this.hasIssues() == other.hasIssues() && Objects.equals(this.issues(), other.issues());
    }

    public final String toString() {
        return ToString.builder((String)"CapabilityHealth").add("Issues", this.hasIssues() ? this.issues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<CapabilityIssue>>> map = new HashMap<String, SdkField<List<CapabilityIssue>>>();
        map.put("issues", ISSUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityHealth, T> g) {
        return obj -> g.apply((CapabilityHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CapabilityIssue> issues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityHealth model) {
            this.issues(model.issues);
        }

        public final List<CapabilityIssue.Builder> getIssues() {
            List<CapabilityIssue.Builder> result = CapabilityIssueListCopier.copyToBuilder(this.issues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssues(Collection<CapabilityIssue.BuilderImpl> issues) {
            this.issues = CapabilityIssueListCopier.copyFromBuilder(issues);
        }

        @Override
        public final Builder issues(Collection<CapabilityIssue> issues) {
            this.issues = CapabilityIssueListCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(CapabilityIssue ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(Consumer<CapabilityIssue.Builder> ... issues) {
            this.issues(Stream.of(issues).map(c -> (CapabilityIssue)((CapabilityIssue.Builder)CapabilityIssue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapabilityHealth build() {
            return new CapabilityHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapabilityHealth> {
        public Builder issues(Collection<CapabilityIssue> var1);

        public Builder issues(CapabilityIssue ... var1);

        public Builder issues(Consumer<CapabilityIssue.Builder> ... var1);
    }
}

