/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapabilityStatus {
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    ACTIVE("ACTIVE"),
    DEGRADED("DEGRADED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapabilityStatus> VALUE_MAP;
    private final String value;

    private CapabilityStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapabilityStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapabilityStatus> knownValues() {
        EnumSet<CapabilityStatus> knownValues = EnumSet.allOf(CapabilityStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapabilityStatus.class, CapabilityStatus::toString);
    }
}

