/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterVersionStatus {
    UNSUPPORTED("unsupported"),
    STANDARD_SUPPORT("standard-support"),
    EXTENDED_SUPPORT("extended-support"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterVersionStatus> VALUE_MAP;
    private final String value;

    private ClusterVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterVersionStatus> knownValues() {
        EnumSet<ClusterVersionStatus> knownValues = EnumSet.allOf(ClusterVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterVersionStatus.class, ClusterVersionStatus::toString);
    }
}

