/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.ProvisionedControlPlaneTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlPlaneScalingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlPlaneScalingConfig> {
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(ControlPlaneScalingConfig.getter(ControlPlaneScalingConfig::tierAsString)).setter(ControlPlaneScalingConfig.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlPlaneScalingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tier;

    private ControlPlaneScalingConfig(BuilderImpl builder) {
        this.tier = builder.tier;
    }

    public final ProvisionedControlPlaneTier tier() {
        return ProvisionedControlPlaneTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPlaneScalingConfig)) {
            return false;
        }
        ControlPlaneScalingConfig other = (ControlPlaneScalingConfig)obj;
        return Objects.equals(this.tierAsString(), other.tierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ControlPlaneScalingConfig").add("Tier", (Object)this.tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tier", TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlPlaneScalingConfig, T> g) {
        return obj -> g.apply((ControlPlaneScalingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPlaneScalingConfig model) {
            this.tier(model.tier);
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ProvisionedControlPlaneTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public ControlPlaneScalingConfig build() {
            return new ControlPlaneScalingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlPlaneScalingConfig> {
        public Builder tier(String var1);

        public Builder tier(ProvisionedControlPlaneTier var1);
    }
}

