/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.NodegroupUpdateStrategies;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodegroupUpdateConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodegroupUpdateConfig> {
    private static final SdkField<Integer> MAX_UNAVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxUnavailable").getter(NodegroupUpdateConfig.getter(NodegroupUpdateConfig::maxUnavailable)).setter(NodegroupUpdateConfig.setter(Builder::maxUnavailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnavailable").build()}).build();
    private static final SdkField<Integer> MAX_UNAVAILABLE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxUnavailablePercentage").getter(NodegroupUpdateConfig.getter(NodegroupUpdateConfig::maxUnavailablePercentage)).setter(NodegroupUpdateConfig.setter(Builder::maxUnavailablePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnavailablePercentage").build()}).build();
    private static final SdkField<String> UPDATE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateStrategy").getter(NodegroupUpdateConfig.getter(NodegroupUpdateConfig::updateStrategyAsString)).setter(NodegroupUpdateConfig.setter(Builder::updateStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_UNAVAILABLE_FIELD, MAX_UNAVAILABLE_PERCENTAGE_FIELD, UPDATE_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodegroupUpdateConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxUnavailable;
    private final Integer maxUnavailablePercentage;
    private final String updateStrategy;

    private NodegroupUpdateConfig(BuilderImpl builder) {
        this.maxUnavailable = builder.maxUnavailable;
        this.maxUnavailablePercentage = builder.maxUnavailablePercentage;
        this.updateStrategy = builder.updateStrategy;
    }

    public final Integer maxUnavailable() {
        return this.maxUnavailable;
    }

    public final Integer maxUnavailablePercentage() {
        return this.maxUnavailablePercentage;
    }

    public final NodegroupUpdateStrategies updateStrategy() {
        return NodegroupUpdateStrategies.fromValue(this.updateStrategy);
    }

    public final String updateStrategyAsString() {
        return this.updateStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnavailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnavailablePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupUpdateConfig)) {
            return false;
        }
        NodegroupUpdateConfig other = (NodegroupUpdateConfig)obj;
        return Objects.equals(this.maxUnavailable(), other.maxUnavailable()) && Objects.equals(this.maxUnavailablePercentage(), other.maxUnavailablePercentage()) && Objects.equals(this.updateStrategyAsString(), other.updateStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodegroupUpdateConfig").add("MaxUnavailable", (Object)this.maxUnavailable()).add("MaxUnavailablePercentage", (Object)this.maxUnavailablePercentage()).add("UpdateStrategy", (Object)this.updateStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxUnavailable": {
                return Optional.ofNullable(clazz.cast(this.maxUnavailable()));
            }
            case "maxUnavailablePercentage": {
                return Optional.ofNullable(clazz.cast(this.maxUnavailablePercentage()));
            }
            case "updateStrategy": {
                return Optional.ofNullable(clazz.cast(this.updateStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxUnavailable", MAX_UNAVAILABLE_FIELD);
        map.put("maxUnavailablePercentage", MAX_UNAVAILABLE_PERCENTAGE_FIELD);
        map.put("updateStrategy", UPDATE_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodegroupUpdateConfig, T> g) {
        return obj -> g.apply((NodegroupUpdateConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxUnavailable;
        private Integer maxUnavailablePercentage;
        private String updateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupUpdateConfig model) {
            this.maxUnavailable(model.maxUnavailable);
            this.maxUnavailablePercentage(model.maxUnavailablePercentage);
            this.updateStrategy(model.updateStrategy);
        }

        public final Integer getMaxUnavailable() {
            return this.maxUnavailable;
        }

        public final void setMaxUnavailable(Integer maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
        }

        @Override
        public final Builder maxUnavailable(Integer maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        public final Integer getMaxUnavailablePercentage() {
            return this.maxUnavailablePercentage;
        }

        public final void setMaxUnavailablePercentage(Integer maxUnavailablePercentage) {
            this.maxUnavailablePercentage = maxUnavailablePercentage;
        }

        @Override
        public final Builder maxUnavailablePercentage(Integer maxUnavailablePercentage) {
            this.maxUnavailablePercentage = maxUnavailablePercentage;
            return this;
        }

        public final String getUpdateStrategy() {
            return this.updateStrategy;
        }

        public final void setUpdateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
        }

        @Override
        public final Builder updateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        @Override
        public final Builder updateStrategy(NodegroupUpdateStrategies updateStrategy) {
            this.updateStrategy(updateStrategy == null ? null : updateStrategy.toString());
            return this;
        }

        public NodegroupUpdateConfig build() {
            return new NodegroupUpdateConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodegroupUpdateConfig> {
        public Builder maxUnavailable(Integer var1);

        public Builder maxUnavailablePercentage(Integer var1);

        public Builder updateStrategy(String var1);

        public Builder updateStrategy(NodegroupUpdateStrategies var1);
    }
}

