/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geomaps.model.ColorScheme;
import software.amazon.awssdk.services.geomaps.model.GeoMapsRequest;
import software.amazon.awssdk.services.geomaps.model.LabelSize;
import software.amazon.awssdk.services.geomaps.model.MapFeatureMode;
import software.amazon.awssdk.services.geomaps.model.ScaleBarUnit;
import software.amazon.awssdk.services.geomaps.model.StaticMapStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStaticMapRequest
extends GeoMapsRequest
implements ToCopyableBuilder<Builder, GetStaticMapRequest> {
    private static final SdkField<String> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BoundingBox").getter(GetStaticMapRequest.getter(GetStaticMapRequest::boundingBox)).setter(GetStaticMapRequest.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bounding-box").build()}).build();
    private static final SdkField<String> BOUNDED_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BoundedPositions").getter(GetStaticMapRequest.getter(GetStaticMapRequest::boundedPositions)).setter(GetStaticMapRequest.setter(Builder::boundedPositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bounded-positions").build()}).build();
    private static final SdkField<String> CENTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Center").getter(GetStaticMapRequest.getter(GetStaticMapRequest::center)).setter(GetStaticMapRequest.setter(Builder::center)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("center").build()}).build();
    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorScheme").getter(GetStaticMapRequest.getter(GetStaticMapRequest::colorSchemeAsString)).setter(GetStaticMapRequest.setter(Builder::colorScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("color-scheme").build()}).build();
    private static final SdkField<String> COMPACT_OVERLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompactOverlay").getter(GetStaticMapRequest.getter(GetStaticMapRequest::compactOverlay)).setter(GetStaticMapRequest.setter(Builder::compactOverlay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("compact-overlay").build()}).build();
    private static final SdkField<Boolean> CROP_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CropLabels").getter(GetStaticMapRequest.getter(GetStaticMapRequest::cropLabels)).setter(GetStaticMapRequest.setter(Builder::cropLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("crop-labels").build()}).build();
    private static final SdkField<String> GEO_JSON_OVERLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeoJsonOverlay").getter(GetStaticMapRequest.getter(GetStaticMapRequest::geoJsonOverlay)).setter(GetStaticMapRequest.setter(Builder::geoJsonOverlay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("geojson-overlay").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(GetStaticMapRequest.getter(GetStaticMapRequest::height)).setter(GetStaticMapRequest.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("height").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetStaticMapRequest.getter(GetStaticMapRequest::key)).setter(GetStaticMapRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<String> LABEL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelSize").getter(GetStaticMapRequest.getter(GetStaticMapRequest::labelSizeAsString)).setter(GetStaticMapRequest.setter(Builder::labelSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("label-size").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(GetStaticMapRequest.getter(GetStaticMapRequest::language)).setter(GetStaticMapRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("lang").build()}).build();
    private static final SdkField<Integer> PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Padding").getter(GetStaticMapRequest.getter(GetStaticMapRequest::padding)).setter(GetStaticMapRequest.setter(Builder::padding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("padding").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(GetStaticMapRequest.getter(GetStaticMapRequest::politicalView)).setter(GetStaticMapRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build()}).build();
    private static final SdkField<String> POINTS_OF_INTERESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PointsOfInterests").getter(GetStaticMapRequest.getter(GetStaticMapRequest::pointsOfInterestsAsString)).setter(GetStaticMapRequest.setter(Builder::pointsOfInterests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pois").build()}).build();
    private static final SdkField<Long> RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Radius").getter(GetStaticMapRequest.getter(GetStaticMapRequest::radius)).setter(GetStaticMapRequest.setter(Builder::radius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("radius").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(GetStaticMapRequest.getter(GetStaticMapRequest::fileName)).setter(GetStaticMapRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()}).build();
    private static final SdkField<String> SCALE_BAR_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScaleBarUnit").getter(GetStaticMapRequest.getter(GetStaticMapRequest::scaleBarUnitAsString)).setter(GetStaticMapRequest.setter(Builder::scaleBarUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scale-unit").build()}).build();
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(GetStaticMapRequest.getter(GetStaticMapRequest::styleAsString)).setter(GetStaticMapRequest.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("style").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(GetStaticMapRequest.getter(GetStaticMapRequest::width)).setter(GetStaticMapRequest.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("width").build()}).build();
    private static final SdkField<Float> ZOOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Zoom").getter(GetStaticMapRequest.getter(GetStaticMapRequest::zoom)).setter(GetStaticMapRequest.setter(Builder::zoom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("zoom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, BOUNDED_POSITIONS_FIELD, CENTER_FIELD, COLOR_SCHEME_FIELD, COMPACT_OVERLAY_FIELD, CROP_LABELS_FIELD, GEO_JSON_OVERLAY_FIELD, HEIGHT_FIELD, KEY_FIELD, LABEL_SIZE_FIELD, LANGUAGE_FIELD, PADDING_FIELD, POLITICAL_VIEW_FIELD, POINTS_OF_INTERESTS_FIELD, RADIUS_FIELD, FILE_NAME_FIELD, SCALE_BAR_UNIT_FIELD, STYLE_FIELD, WIDTH_FIELD, ZOOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStaticMapRequest.memberNameToFieldInitializer();
    private final String boundingBox;
    private final String boundedPositions;
    private final String center;
    private final String colorScheme;
    private final String compactOverlay;
    private final Boolean cropLabels;
    private final String geoJsonOverlay;
    private final Integer height;
    private final String key;
    private final String labelSize;
    private final String language;
    private final Integer padding;
    private final String politicalView;
    private final String pointsOfInterests;
    private final Long radius;
    private final String fileName;
    private final String scaleBarUnit;
    private final String style;
    private final Integer width;
    private final Float zoom;

    private GetStaticMapRequest(BuilderImpl builder) {
        super(builder);
        this.boundingBox = builder.boundingBox;
        this.boundedPositions = builder.boundedPositions;
        this.center = builder.center;
        this.colorScheme = builder.colorScheme;
        this.compactOverlay = builder.compactOverlay;
        this.cropLabels = builder.cropLabels;
        this.geoJsonOverlay = builder.geoJsonOverlay;
        this.height = builder.height;
        this.key = builder.key;
        this.labelSize = builder.labelSize;
        this.language = builder.language;
        this.padding = builder.padding;
        this.politicalView = builder.politicalView;
        this.pointsOfInterests = builder.pointsOfInterests;
        this.radius = builder.radius;
        this.fileName = builder.fileName;
        this.scaleBarUnit = builder.scaleBarUnit;
        this.style = builder.style;
        this.width = builder.width;
        this.zoom = builder.zoom;
    }

    public final String boundingBox() {
        return this.boundingBox;
    }

    public final String boundedPositions() {
        return this.boundedPositions;
    }

    public final String center() {
        return this.center;
    }

    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(this.colorScheme);
    }

    public final String colorSchemeAsString() {
        return this.colorScheme;
    }

    public final String compactOverlay() {
        return this.compactOverlay;
    }

    public final Boolean cropLabels() {
        return this.cropLabels;
    }

    public final String geoJsonOverlay() {
        return this.geoJsonOverlay;
    }

    public final Integer height() {
        return this.height;
    }

    public final String key() {
        return this.key;
    }

    public final LabelSize labelSize() {
        return LabelSize.fromValue(this.labelSize);
    }

    public final String labelSizeAsString() {
        return this.labelSize;
    }

    public final String language() {
        return this.language;
    }

    public final Integer padding() {
        return this.padding;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final MapFeatureMode pointsOfInterests() {
        return MapFeatureMode.fromValue(this.pointsOfInterests);
    }

    public final String pointsOfInterestsAsString() {
        return this.pointsOfInterests;
    }

    public final Long radius() {
        return this.radius;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final ScaleBarUnit scaleBarUnit() {
        return ScaleBarUnit.fromValue(this.scaleBarUnit);
    }

    public final String scaleBarUnitAsString() {
        return this.scaleBarUnit;
    }

    public final StaticMapStyle style() {
        return StaticMapStyle.fromValue(this.style);
    }

    public final String styleAsString() {
        return this.style;
    }

    public final Integer width() {
        return this.width;
    }

    public final Float zoom() {
        return this.zoom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundedPositions());
        hashCode = 31 * hashCode + Objects.hashCode(this.center());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compactOverlay());
        hashCode = 31 * hashCode + Objects.hashCode(this.cropLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoJsonOverlay());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.padding());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointsOfInterestsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.radius());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleBarUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticMapRequest)) {
            return false;
        }
        GetStaticMapRequest other = (GetStaticMapRequest)((Object)obj);
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.boundedPositions(), other.boundedPositions()) && Objects.equals(this.center(), other.center()) && Objects.equals(this.colorSchemeAsString(), other.colorSchemeAsString()) && Objects.equals(this.compactOverlay(), other.compactOverlay()) && Objects.equals(this.cropLabels(), other.cropLabels()) && Objects.equals(this.geoJsonOverlay(), other.geoJsonOverlay()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.labelSizeAsString(), other.labelSizeAsString()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.padding(), other.padding()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.pointsOfInterestsAsString(), other.pointsOfInterestsAsString()) && Objects.equals(this.radius(), other.radius()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.scaleBarUnitAsString(), other.scaleBarUnitAsString()) && Objects.equals(this.styleAsString(), other.styleAsString()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.zoom(), other.zoom());
    }

    public final String toString() {
        return ToString.builder((String)"GetStaticMapRequest").add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("BoundedPositions", (Object)(this.boundedPositions() == null ? null : "*** Sensitive Data Redacted ***")).add("Center", (Object)(this.center() == null ? null : "*** Sensitive Data Redacted ***")).add("ColorScheme", (Object)this.colorSchemeAsString()).add("CompactOverlay", (Object)(this.compactOverlay() == null ? null : "*** Sensitive Data Redacted ***")).add("CropLabels", (Object)this.cropLabels()).add("GeoJsonOverlay", (Object)(this.geoJsonOverlay() == null ? null : "*** Sensitive Data Redacted ***")).add("Height", (Object)(this.height() == null ? null : "*** Sensitive Data Redacted ***")).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("LabelSize", (Object)this.labelSizeAsString()).add("Language", (Object)this.language()).add("Padding", (Object)(this.padding() == null ? null : "*** Sensitive Data Redacted ***")).add("PoliticalView", (Object)(this.politicalView() == null ? null : "*** Sensitive Data Redacted ***")).add("PointsOfInterests", (Object)this.pointsOfInterestsAsString()).add("Radius", (Object)(this.radius() == null ? null : "*** Sensitive Data Redacted ***")).add("FileName", (Object)this.fileName()).add("ScaleBarUnit", (Object)this.scaleBarUnitAsString()).add("Style", (Object)this.styleAsString()).add("Width", (Object)(this.width() == null ? null : "*** Sensitive Data Redacted ***")).add("Zoom", (Object)(this.zoom() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "BoundedPositions": {
                return Optional.ofNullable(clazz.cast(this.boundedPositions()));
            }
            case "Center": {
                return Optional.ofNullable(clazz.cast(this.center()));
            }
            case "ColorScheme": {
                return Optional.ofNullable(clazz.cast(this.colorSchemeAsString()));
            }
            case "CompactOverlay": {
                return Optional.ofNullable(clazz.cast(this.compactOverlay()));
            }
            case "CropLabels": {
                return Optional.ofNullable(clazz.cast(this.cropLabels()));
            }
            case "GeoJsonOverlay": {
                return Optional.ofNullable(clazz.cast(this.geoJsonOverlay()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "LabelSize": {
                return Optional.ofNullable(clazz.cast(this.labelSizeAsString()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "Padding": {
                return Optional.ofNullable(clazz.cast(this.padding()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "PointsOfInterests": {
                return Optional.ofNullable(clazz.cast(this.pointsOfInterestsAsString()));
            }
            case "Radius": {
                return Optional.ofNullable(clazz.cast(this.radius()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "ScaleBarUnit": {
                return Optional.ofNullable(clazz.cast(this.scaleBarUnitAsString()));
            }
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.styleAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "Zoom": {
                return Optional.ofNullable(clazz.cast(this.zoom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bounding-box", BOUNDING_BOX_FIELD);
        map.put("bounded-positions", BOUNDED_POSITIONS_FIELD);
        map.put("center", CENTER_FIELD);
        map.put("color-scheme", COLOR_SCHEME_FIELD);
        map.put("compact-overlay", COMPACT_OVERLAY_FIELD);
        map.put("crop-labels", CROP_LABELS_FIELD);
        map.put("geojson-overlay", GEO_JSON_OVERLAY_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("key", KEY_FIELD);
        map.put("label-size", LABEL_SIZE_FIELD);
        map.put("lang", LANGUAGE_FIELD);
        map.put("padding", PADDING_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("pois", POINTS_OF_INTERESTS_FIELD);
        map.put("radius", RADIUS_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("scale-unit", SCALE_BAR_UNIT_FIELD);
        map.put("style", STYLE_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("zoom", ZOOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStaticMapRequest, T> g) {
        return obj -> g.apply((GetStaticMapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsRequest.BuilderImpl
    implements Builder {
        private String boundingBox;
        private String boundedPositions;
        private String center;
        private String colorScheme;
        private String compactOverlay;
        private Boolean cropLabels;
        private String geoJsonOverlay;
        private Integer height;
        private String key;
        private String labelSize;
        private String language;
        private Integer padding;
        private String politicalView;
        private String pointsOfInterests;
        private Long radius;
        private String fileName;
        private String scaleBarUnit;
        private String style;
        private Integer width;
        private Float zoom;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticMapRequest model) {
            super(model);
            this.boundingBox(model.boundingBox);
            this.boundedPositions(model.boundedPositions);
            this.center(model.center);
            this.colorScheme(model.colorScheme);
            this.compactOverlay(model.compactOverlay);
            this.cropLabels(model.cropLabels);
            this.geoJsonOverlay(model.geoJsonOverlay);
            this.height(model.height);
            this.key(model.key);
            this.labelSize(model.labelSize);
            this.language(model.language);
            this.padding(model.padding);
            this.politicalView(model.politicalView);
            this.pointsOfInterests(model.pointsOfInterests);
            this.radius(model.radius);
            this.fileName(model.fileName);
            this.scaleBarUnit(model.scaleBarUnit);
            this.style(model.style);
            this.width(model.width);
            this.zoom(model.zoom);
        }

        public final String getBoundingBox() {
            return this.boundingBox;
        }

        public final void setBoundingBox(String boundingBox) {
            this.boundingBox = boundingBox;
        }

        @Override
        public final Builder boundingBox(String boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final String getBoundedPositions() {
            return this.boundedPositions;
        }

        public final void setBoundedPositions(String boundedPositions) {
            this.boundedPositions = boundedPositions;
        }

        @Override
        public final Builder boundedPositions(String boundedPositions) {
            this.boundedPositions = boundedPositions;
            return this;
        }

        public final String getCenter() {
            return this.center;
        }

        public final void setCenter(String center) {
            this.center = center;
        }

        @Override
        public final Builder center(String center) {
            this.center = center;
            return this;
        }

        public final String getColorScheme() {
            return this.colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getCompactOverlay() {
            return this.compactOverlay;
        }

        public final void setCompactOverlay(String compactOverlay) {
            this.compactOverlay = compactOverlay;
        }

        @Override
        public final Builder compactOverlay(String compactOverlay) {
            this.compactOverlay = compactOverlay;
            return this;
        }

        public final Boolean getCropLabels() {
            return this.cropLabels;
        }

        public final void setCropLabels(Boolean cropLabels) {
            this.cropLabels = cropLabels;
        }

        @Override
        public final Builder cropLabels(Boolean cropLabels) {
            this.cropLabels = cropLabels;
            return this;
        }

        public final String getGeoJsonOverlay() {
            return this.geoJsonOverlay;
        }

        public final void setGeoJsonOverlay(String geoJsonOverlay) {
            this.geoJsonOverlay = geoJsonOverlay;
        }

        @Override
        public final Builder geoJsonOverlay(String geoJsonOverlay) {
            this.geoJsonOverlay = geoJsonOverlay;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getLabelSize() {
            return this.labelSize;
        }

        public final void setLabelSize(String labelSize) {
            this.labelSize = labelSize;
        }

        @Override
        public final Builder labelSize(String labelSize) {
            this.labelSize = labelSize;
            return this;
        }

        @Override
        public final Builder labelSize(LabelSize labelSize) {
            this.labelSize(labelSize == null ? null : labelSize.toString());
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Integer getPadding() {
            return this.padding;
        }

        public final void setPadding(Integer padding) {
            this.padding = padding;
        }

        @Override
        public final Builder padding(Integer padding) {
            this.padding = padding;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getPointsOfInterests() {
            return this.pointsOfInterests;
        }

        public final void setPointsOfInterests(String pointsOfInterests) {
            this.pointsOfInterests = pointsOfInterests;
        }

        @Override
        public final Builder pointsOfInterests(String pointsOfInterests) {
            this.pointsOfInterests = pointsOfInterests;
            return this;
        }

        @Override
        public final Builder pointsOfInterests(MapFeatureMode pointsOfInterests) {
            this.pointsOfInterests(pointsOfInterests == null ? null : pointsOfInterests.toString());
            return this;
        }

        public final Long getRadius() {
            return this.radius;
        }

        public final void setRadius(Long radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Long radius) {
            this.radius = radius;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getScaleBarUnit() {
            return this.scaleBarUnit;
        }

        public final void setScaleBarUnit(String scaleBarUnit) {
            this.scaleBarUnit = scaleBarUnit;
        }

        @Override
        public final Builder scaleBarUnit(String scaleBarUnit) {
            this.scaleBarUnit = scaleBarUnit;
            return this;
        }

        @Override
        public final Builder scaleBarUnit(ScaleBarUnit scaleBarUnit) {
            this.scaleBarUnit(scaleBarUnit == null ? null : scaleBarUnit.toString());
            return this;
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(StaticMapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Float getZoom() {
            return this.zoom;
        }

        public final void setZoom(Float zoom) {
            this.zoom = zoom;
        }

        @Override
        public final Builder zoom(Float zoom) {
            this.zoom = zoom;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStaticMapRequest build() {
            return new GetStaticMapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoMapsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStaticMapRequest> {
        public Builder boundingBox(String var1);

        public Builder boundedPositions(String var1);

        public Builder center(String var1);

        public Builder colorScheme(String var1);

        public Builder colorScheme(ColorScheme var1);

        public Builder compactOverlay(String var1);

        public Builder cropLabels(Boolean var1);

        public Builder geoJsonOverlay(String var1);

        public Builder height(Integer var1);

        public Builder key(String var1);

        public Builder labelSize(String var1);

        public Builder labelSize(LabelSize var1);

        public Builder language(String var1);

        public Builder padding(Integer var1);

        public Builder politicalView(String var1);

        public Builder pointsOfInterests(String var1);

        public Builder pointsOfInterests(MapFeatureMode var1);

        public Builder radius(Long var1);

        public Builder fileName(String var1);

        public Builder scaleBarUnit(String var1);

        public Builder scaleBarUnit(ScaleBarUnit var1);

        public Builder style(String var1);

        public Builder style(StaticMapStyle var1);

        public Builder width(Integer var1);

        public Builder zoom(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

