/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParsedQueryComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParsedQueryComponent> {
    private static final SdkField<Integer> START_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartIndex").getter(ParsedQueryComponent.getter(ParsedQueryComponent::startIndex)).setter(ParsedQueryComponent.setter(Builder::startIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartIndex").build()}).build();
    private static final SdkField<Integer> END_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndIndex").getter(ParsedQueryComponent.getter(ParsedQueryComponent::endIndex)).setter(ParsedQueryComponent.setter(Builder::endIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndIndex").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ParsedQueryComponent.getter(ParsedQueryComponent::value)).setter(ParsedQueryComponent.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> QUERY_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryComponent").getter(ParsedQueryComponent.getter(ParsedQueryComponent::queryComponent)).setter(ParsedQueryComponent.setter(Builder::queryComponent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryComponent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_INDEX_FIELD, END_INDEX_FIELD, VALUE_FIELD, QUERY_COMPONENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParsedQueryComponent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer startIndex;
    private final Integer endIndex;
    private final String value;
    private final String queryComponent;

    private ParsedQueryComponent(BuilderImpl builder) {
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.value = builder.value;
        this.queryComponent = builder.queryComponent;
    }

    public final Integer startIndex() {
        return this.startIndex;
    }

    public final Integer endIndex() {
        return this.endIndex;
    }

    public final String value() {
        return this.value;
    }

    public final String queryComponent() {
        return this.queryComponent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.endIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryComponent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsedQueryComponent)) {
            return false;
        }
        ParsedQueryComponent other = (ParsedQueryComponent)obj;
        return Objects.equals(this.startIndex(), other.startIndex()) && Objects.equals(this.endIndex(), other.endIndex()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.queryComponent(), other.queryComponent());
    }

    public final String toString() {
        return ToString.builder((String)"ParsedQueryComponent").add("StartIndex", (Object)this.startIndex()).add("EndIndex", (Object)this.endIndex()).add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryComponent", (Object)(this.queryComponent() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartIndex": {
                return Optional.ofNullable(clazz.cast(this.startIndex()));
            }
            case "EndIndex": {
                return Optional.ofNullable(clazz.cast(this.endIndex()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "QueryComponent": {
                return Optional.ofNullable(clazz.cast(this.queryComponent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartIndex", START_INDEX_FIELD);
        map.put("EndIndex", END_INDEX_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("QueryComponent", QUERY_COMPONENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParsedQueryComponent, T> g) {
        return obj -> g.apply((ParsedQueryComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer startIndex;
        private Integer endIndex;
        private String value;
        private String queryComponent;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsedQueryComponent model) {
            this.startIndex(model.startIndex);
            this.endIndex(model.endIndex);
            this.value(model.value);
            this.queryComponent(model.queryComponent);
        }

        public final Integer getStartIndex() {
            return this.startIndex;
        }

        public final void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public final Builder startIndex(Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Integer getEndIndex() {
            return this.endIndex;
        }

        public final void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }

        @Override
        public final Builder endIndex(Integer endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getQueryComponent() {
            return this.queryComponent;
        }

        public final void setQueryComponent(String queryComponent) {
            this.queryComponent = queryComponent;
        }

        @Override
        public final Builder queryComponent(String queryComponent) {
            this.queryComponent = queryComponent;
            return this;
        }

        public ParsedQueryComponent build() {
            return new ParsedQueryComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParsedQueryComponent> {
        public Builder startIndex(Integer var1);

        public Builder endIndex(Integer var1);

        public Builder value(String var1);

        public Builder queryComponent(String var1);
    }
}

