/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelIdListCopier;
import software.amazon.awssdk.services.iotsitewise.model.MatchedDataBinding;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputationModelDataBindingUsageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputationModelDataBindingUsageSummary> {
    private static final SdkField<List<String>> COMPUTATION_MODEL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computationModelIds").getter(ComputationModelDataBindingUsageSummary.getter(ComputationModelDataBindingUsageSummary::computationModelIds)).setter(ComputationModelDataBindingUsageSummary.setter(Builder::computationModelIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MatchedDataBinding> MATCHED_DATA_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("matchedDataBinding").getter(ComputationModelDataBindingUsageSummary.getter(ComputationModelDataBindingUsageSummary::matchedDataBinding)).setter(ComputationModelDataBindingUsageSummary.setter(Builder::matchedDataBinding)).constructor(MatchedDataBinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchedDataBinding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_IDS_FIELD, MATCHED_DATA_BINDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputationModelDataBindingUsageSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> computationModelIds;
    private final MatchedDataBinding matchedDataBinding;

    private ComputationModelDataBindingUsageSummary(BuilderImpl builder) {
        this.computationModelIds = builder.computationModelIds;
        this.matchedDataBinding = builder.matchedDataBinding;
    }

    public final boolean hasComputationModelIds() {
        return this.computationModelIds != null && !(this.computationModelIds instanceof SdkAutoConstructList);
    }

    public final List<String> computationModelIds() {
        return this.computationModelIds;
    }

    public final MatchedDataBinding matchedDataBinding() {
        return this.matchedDataBinding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelIds() ? this.computationModelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedDataBinding());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelDataBindingUsageSummary)) {
            return false;
        }
        ComputationModelDataBindingUsageSummary other = (ComputationModelDataBindingUsageSummary)obj;
        return this.hasComputationModelIds() == other.hasComputationModelIds() && Objects.equals(this.computationModelIds(), other.computationModelIds()) && Objects.equals(this.matchedDataBinding(), other.matchedDataBinding());
    }

    public final String toString() {
        return ToString.builder((String)"ComputationModelDataBindingUsageSummary").add("ComputationModelIds", this.hasComputationModelIds() ? this.computationModelIds() : null).add("MatchedDataBinding", (Object)this.matchedDataBinding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelIds": {
                return Optional.ofNullable(clazz.cast(this.computationModelIds()));
            }
            case "matchedDataBinding": {
                return Optional.ofNullable(clazz.cast(this.matchedDataBinding()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelIds", COMPUTATION_MODEL_IDS_FIELD);
        map.put("matchedDataBinding", MATCHED_DATA_BINDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelDataBindingUsageSummary, T> g) {
        return obj -> g.apply((ComputationModelDataBindingUsageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> computationModelIds = DefaultSdkAutoConstructList.getInstance();
        private MatchedDataBinding matchedDataBinding;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelDataBindingUsageSummary model) {
            this.computationModelIds(model.computationModelIds);
            this.matchedDataBinding(model.matchedDataBinding);
        }

        public final Collection<String> getComputationModelIds() {
            if (this.computationModelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.computationModelIds;
        }

        public final void setComputationModelIds(Collection<String> computationModelIds) {
            this.computationModelIds = ComputationModelIdListCopier.copy(computationModelIds);
        }

        @Override
        public final Builder computationModelIds(Collection<String> computationModelIds) {
            this.computationModelIds = ComputationModelIdListCopier.copy(computationModelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computationModelIds(String ... computationModelIds) {
            this.computationModelIds(Arrays.asList(computationModelIds));
            return this;
        }

        public final MatchedDataBinding.Builder getMatchedDataBinding() {
            return this.matchedDataBinding != null ? this.matchedDataBinding.toBuilder() : null;
        }

        public final void setMatchedDataBinding(MatchedDataBinding.BuilderImpl matchedDataBinding) {
            this.matchedDataBinding = matchedDataBinding != null ? matchedDataBinding.build() : null;
        }

        @Override
        public final Builder matchedDataBinding(MatchedDataBinding matchedDataBinding) {
            this.matchedDataBinding = matchedDataBinding;
            return this;
        }

        public ComputationModelDataBindingUsageSummary build() {
            return new ComputationModelDataBindingUsageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputationModelDataBindingUsageSummary> {
        public Builder computationModelIds(Collection<String> var1);

        public Builder computationModelIds(String ... var1);

        public Builder matchedDataBinding(MatchedDataBinding var1);

        default public Builder matchedDataBinding(Consumer<MatchedDataBinding.Builder> matchedDataBinding) {
            return this.matchedDataBinding((MatchedDataBinding)((MatchedDataBinding.Builder)MatchedDataBinding.builder().applyMutation(matchedDataBinding)).build());
        }
    }
}

