/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputationModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateComputationModelResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(CreateComputationModelResponse.getter(CreateComputationModelResponse::computationModelId)).setter(CreateComputationModelResponse.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelArn").getter(CreateComputationModelResponse.getter(CreateComputationModelResponse::computationModelArn)).setter(CreateComputationModelResponse.setter(Builder::computationModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelArn").build()}).build();
    private static final SdkField<ComputationModelStatus> COMPUTATION_MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computationModelStatus").getter(CreateComputationModelResponse.getter(CreateComputationModelResponse::computationModelStatus)).setter(CreateComputationModelResponse.setter(Builder::computationModelStatus)).constructor(ComputationModelStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, COMPUTATION_MODEL_ARN_FIELD, COMPUTATION_MODEL_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComputationModelResponse.memberNameToFieldInitializer();
    private final String computationModelId;
    private final String computationModelArn;
    private final ComputationModelStatus computationModelStatus;

    private CreateComputationModelResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelArn = builder.computationModelArn;
        this.computationModelStatus = builder.computationModelStatus;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final String computationModelArn() {
        return this.computationModelArn;
    }

    public final ComputationModelStatus computationModelStatus() {
        return this.computationModelStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputationModelResponse)) {
            return false;
        }
        CreateComputationModelResponse other = (CreateComputationModelResponse)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.computationModelArn(), other.computationModelArn()) && Objects.equals(this.computationModelStatus(), other.computationModelStatus());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputationModelResponse").add("ComputationModelId", (Object)this.computationModelId()).add("ComputationModelArn", (Object)this.computationModelArn()).add("ComputationModelStatus", (Object)this.computationModelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "computationModelArn": {
                return Optional.ofNullable(clazz.cast(this.computationModelArn()));
            }
            case "computationModelStatus": {
                return Optional.ofNullable(clazz.cast(this.computationModelStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelArn", COMPUTATION_MODEL_ARN_FIELD);
        map.put("computationModelStatus", COMPUTATION_MODEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputationModelResponse, T> g) {
        return obj -> g.apply((CreateComputationModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String computationModelId;
        private String computationModelArn;
        private ComputationModelStatus computationModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputationModelResponse model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.computationModelArn(model.computationModelArn);
            this.computationModelStatus(model.computationModelStatus);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelArn() {
            return this.computationModelArn;
        }

        public final void setComputationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
        }

        @Override
        public final Builder computationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
            return this;
        }

        public final ComputationModelStatus.Builder getComputationModelStatus() {
            return this.computationModelStatus != null ? this.computationModelStatus.toBuilder() : null;
        }

        public final void setComputationModelStatus(ComputationModelStatus.BuilderImpl computationModelStatus) {
            this.computationModelStatus = computationModelStatus != null ? computationModelStatus.build() : null;
        }

        @Override
        public final Builder computationModelStatus(ComputationModelStatus computationModelStatus) {
            this.computationModelStatus = computationModelStatus;
            return this;
        }

        @Override
        public CreateComputationModelResponse build() {
            return new CreateComputationModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputationModelResponse> {
        public Builder computationModelId(String var1);

        public Builder computationModelArn(String var1);

        public Builder computationModelStatus(ComputationModelStatus var1);

        default public Builder computationModelStatus(Consumer<ComputationModelStatus.Builder> computationModelStatus) {
            return this.computationModelStatus((ComputationModelStatus)((ComputationModelStatus.Builder)ComputationModelStatus.builder().applyMutation(computationModelStatus)).build());
        }
    }
}

