/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputationModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DescribeComputationModelRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(DescribeComputationModelRequest.getter(DescribeComputationModelRequest::computationModelId)).setter(DescribeComputationModelRequest.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("computationModelId").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelVersion").getter(DescribeComputationModelRequest.getter(DescribeComputationModelRequest::computationModelVersion)).setter(DescribeComputationModelRequest.setter(Builder::computationModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("computationModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, COMPUTATION_MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComputationModelRequest.memberNameToFieldInitializer();
    private final String computationModelId;
    private final String computationModelVersion;

    private DescribeComputationModelRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelVersion = builder.computationModelVersion;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final String computationModelVersion() {
        return this.computationModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelRequest)) {
            return false;
        }
        DescribeComputationModelRequest other = (DescribeComputationModelRequest)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.computationModelVersion(), other.computationModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputationModelRequest").add("ComputationModelId", (Object)this.computationModelId()).add("ComputationModelVersion", (Object)this.computationModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "computationModelVersion": {
                return Optional.ofNullable(clazz.cast(this.computationModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelVersion", COMPUTATION_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelRequest, T> g) {
        return obj -> g.apply((DescribeComputationModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String computationModelId;
        private String computationModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelRequest model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.computationModelVersion(model.computationModelVersion);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelVersion() {
            return this.computationModelVersion;
        }

        public final void setComputationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
        }

        @Override
        public final Builder computationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputationModelRequest build() {
            return new DescribeComputationModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputationModelRequest> {
        public Builder computationModelId(String var1);

        public Builder computationModelVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

