/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iotsitewise.model.Row;

public class ExecuteQueryIterable
implements SdkIterable<ExecuteQueryResponse> {
    private final IoTSiteWiseClient client;
    private final ExecuteQueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ExecuteQueryIterable(IoTSiteWiseClient client, ExecuteQueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ExecuteQueryResponseFetcher();
    }

    public Iterator<ExecuteQueryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Row> rows() {
        Function<ExecuteQueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ExecuteQueryResponseFetcher
    implements SyncPageFetcher<ExecuteQueryResponse> {
        private ExecuteQueryResponseFetcher() {
        }

        public boolean hasNextPage(ExecuteQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ExecuteQueryResponse nextPage(ExecuteQueryResponse previousPage) {
            if (previousPage == null) {
                return ExecuteQueryIterable.this.client.executeQuery(ExecuteQueryIterable.this.firstRequest);
            }
            return ExecuteQueryIterable.this.client.executeQuery((ExecuteQueryRequest)((Object)ExecuteQueryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

