/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelsResponse;

public class ListComputationModelsIterable
implements SdkIterable<ListComputationModelsResponse> {
    private final IoTSiteWiseClient client;
    private final ListComputationModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputationModelsIterable(IoTSiteWiseClient client, ListComputationModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComputationModelsResponseFetcher();
    }

    public Iterator<ListComputationModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputationModelSummary> computationModelSummaries() {
        Function<ListComputationModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computationModelSummaries() != null) {
                return response.computationModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputationModelsResponseFetcher
    implements SyncPageFetcher<ListComputationModelsResponse> {
        private ListComputationModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputationModelsResponse nextPage(ListComputationModelsResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelsIterable.this.client.listComputationModels(ListComputationModelsIterable.this.firstRequest);
            }
            return ListComputationModelsIterable.this.client.listComputationModels((ListComputationModelsRequest)((Object)ListComputationModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

