/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.GroupType;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupUpdateType;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentPropertyGroupRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentPropertyGroupRequest> {
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupType").getter(ComponentPropertyGroupRequest.getter(ComponentPropertyGroupRequest::groupTypeAsString)).setter(ComponentPropertyGroupRequest.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupType").build()}).build();
    private static final SdkField<List<String>> PROPERTY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyNames").getter(ComponentPropertyGroupRequest.getter(ComponentPropertyGroupRequest::propertyNames)).setter(ComponentPropertyGroupRequest.setter(Builder::propertyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(ComponentPropertyGroupRequest.getter(ComponentPropertyGroupRequest::updateTypeAsString)).setter(ComponentPropertyGroupRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_TYPE_FIELD, PROPERTY_NAMES_FIELD, UPDATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentPropertyGroupRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupType;
    private final List<String> propertyNames;
    private final String updateType;

    private ComponentPropertyGroupRequest(BuilderImpl builder) {
        this.groupType = builder.groupType;
        this.propertyNames = builder.propertyNames;
        this.updateType = builder.updateType;
    }

    public final GroupType groupType() {
        return GroupType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final boolean hasPropertyNames() {
        return this.propertyNames != null && !(this.propertyNames instanceof SdkAutoConstructList);
    }

    public final List<String> propertyNames() {
        return this.propertyNames;
    }

    public final PropertyGroupUpdateType updateType() {
        return PropertyGroupUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyNames() ? this.propertyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentPropertyGroupRequest)) {
            return false;
        }
        ComponentPropertyGroupRequest other = (ComponentPropertyGroupRequest)obj;
        return Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && this.hasPropertyNames() == other.hasPropertyNames() && Objects.equals(this.propertyNames(), other.propertyNames()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentPropertyGroupRequest").add("GroupType", (Object)this.groupTypeAsString()).add("PropertyNames", this.hasPropertyNames() ? this.propertyNames() : null).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "propertyNames": {
                return Optional.ofNullable(clazz.cast(this.propertyNames()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupType", GROUP_TYPE_FIELD);
        map.put("propertyNames", PROPERTY_NAMES_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentPropertyGroupRequest, T> g) {
        return obj -> g.apply((ComponentPropertyGroupRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupType;
        private List<String> propertyNames = DefaultSdkAutoConstructList.getInstance();
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentPropertyGroupRequest model) {
            this.groupType(model.groupType);
            this.propertyNames(model.propertyNames);
            this.updateType(model.updateType);
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Collection<String> getPropertyNames() {
            if (this.propertyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertyNames;
        }

        public final void setPropertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
        }

        @Override
        public final Builder propertyNames(Collection<String> propertyNames) {
            this.propertyNames = PropertyNamesCopier.copy(propertyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyNames(String ... propertyNames) {
            this.propertyNames(Arrays.asList(propertyNames));
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(PropertyGroupUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public ComponentPropertyGroupRequest build() {
            return new ComponentPropertyGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentPropertyGroupRequest> {
        public Builder groupType(String var1);

        public Builder groupType(GroupType var1);

        public Builder propertyNames(Collection<String> var1);

        public Builder propertyNames(String ... var1);

        public Builder updateType(String var1);

        public Builder updateType(PropertyGroupUpdateType var1);
    }
}

