/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetadataTransferJobsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListMetadataTransferJobsFilter> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(ListMetadataTransferJobsFilter.getter(ListMetadataTransferJobsFilter::workspaceId)).setter(ListMetadataTransferJobsFilter.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ListMetadataTransferJobsFilter.getter(ListMetadataTransferJobsFilter::stateAsString)).setter(ListMetadataTransferJobsFilter.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMetadataTransferJobsFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workspaceId;
    private final String state;
    private final Type type;

    private ListMetadataTransferJobsFilter(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.state = builder.state;
        this.type = builder.type;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final MetadataTransferJobState state() {
        return MetadataTransferJobState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetadataTransferJobsFilter)) {
            return false;
        }
        ListMetadataTransferJobsFilter other = (ListMetadataTransferJobsFilter)obj;
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetadataTransferJobsFilter").add("WorkspaceId", (Object)this.workspaceId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public static ListMetadataTransferJobsFilter fromWorkspaceId(String workspaceId) {
        return (ListMetadataTransferJobsFilter)ListMetadataTransferJobsFilter.builder().workspaceId(workspaceId).build();
    }

    public static ListMetadataTransferJobsFilter fromState(String state) {
        return (ListMetadataTransferJobsFilter)ListMetadataTransferJobsFilter.builder().state(state).build();
    }

    public static ListMetadataTransferJobsFilter fromState(MetadataTransferJobState state) {
        return (ListMetadataTransferJobsFilter)ListMetadataTransferJobsFilter.builder().state(state).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetadataTransferJobsFilter, T> g) {
        return obj -> g.apply((ListMetadataTransferJobsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        WORKSPACE_ID,
        STATE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String workspaceId;
        private String state;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetadataTransferJobsFilter model) {
            this.workspaceId(model.workspaceId);
            this.state(model.state);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            String oldValue = this.workspaceId;
            this.workspaceId = workspaceId;
            this.handleUnionValueChange(Type.WORKSPACE_ID, oldValue, this.workspaceId);
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            String oldValue = this.workspaceId;
            this.workspaceId = workspaceId;
            this.handleUnionValueChange(Type.WORKSPACE_ID, oldValue, this.workspaceId);
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            String oldValue = this.state;
            this.state = state;
            this.handleUnionValueChange(Type.STATE, oldValue, this.state);
        }

        @Override
        public final Builder state(String state) {
            String oldValue = this.state;
            this.state = state;
            this.handleUnionValueChange(Type.STATE, oldValue, this.state);
            return this;
        }

        @Override
        public final Builder state(MetadataTransferJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public ListMetadataTransferJobsFilter build() {
            return new ListMetadataTransferJobsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListMetadataTransferJobsFilter> {
        public Builder workspaceId(String var1);

        public Builder state(String var1);

        public Builder state(MetadataTransferJobState var1);
    }
}

