/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SceneSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SceneSummary> {
    private static final SdkField<String> SCENE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sceneId").getter(SceneSummary.getter(SceneSummary::sceneId)).setter(SceneSummary.setter(Builder::sceneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()}).build();
    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentLocation").getter(SceneSummary.getter(SceneSummary::contentLocation)).setter(SceneSummary.setter(Builder::contentLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SceneSummary.getter(SceneSummary::arn)).setter(SceneSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(SceneSummary.getter(SceneSummary::creationDateTime)).setter(SceneSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(SceneSummary.getter(SceneSummary::updateDateTime)).setter(SceneSummary.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SceneSummary.getter(SceneSummary::description)).setter(SceneSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCENE_ID_FIELD, CONTENT_LOCATION_FIELD, ARN_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SceneSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sceneId;
    private final String contentLocation;
    private final String arn;
    private final Instant creationDateTime;
    private final Instant updateDateTime;
    private final String description;

    private SceneSummary(BuilderImpl builder) {
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.arn = builder.arn;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.description = builder.description;
    }

    public final String sceneId() {
        return this.sceneId;
    }

    public final String contentLocation() {
        return this.contentLocation;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SceneSummary)) {
            return false;
        }
        SceneSummary other = (SceneSummary)obj;
        return Objects.equals(this.sceneId(), other.sceneId()) && Objects.equals(this.contentLocation(), other.contentLocation()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"SceneSummary").add("SceneId", (Object)this.sceneId()).add("ContentLocation", (Object)this.contentLocation()).add("Arn", (Object)this.arn()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sceneId": {
                return Optional.ofNullable(clazz.cast(this.sceneId()));
            }
            case "contentLocation": {
                return Optional.ofNullable(clazz.cast(this.contentLocation()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneId", SCENE_ID_FIELD);
        map.put("contentLocation", CONTENT_LOCATION_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SceneSummary, T> g) {
        return obj -> g.apply((SceneSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sceneId;
        private String contentLocation;
        private String arn;
        private Instant creationDateTime;
        private Instant updateDateTime;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SceneSummary model) {
            this.sceneId(model.sceneId);
            this.contentLocation(model.contentLocation);
            this.arn(model.arn);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
            this.description(model.description);
        }

        public final String getSceneId() {
            return this.sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return this.contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public SceneSummary build() {
            return new SceneSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SceneSummary> {
        public Builder sceneId(String var1);

        public Builder contentLocation(String var1);

        public Builder arn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);

        public Builder description(String var1);
    }
}

