/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;

public class ListComponentTypesPublisher
implements SdkPublisher<ListComponentTypesResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListComponentTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentTypesPublisher(IoTTwinMakerAsyncClient client, ListComponentTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentTypesPublisher(IoTTwinMakerAsyncClient client, ListComponentTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListComponentTypesResponseFetcher
    implements AsyncPageFetcher<ListComponentTypesResponse> {
        private ListComponentTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentTypesResponse> nextPage(ListComponentTypesResponse previousPage) {
            if (previousPage == null) {
                return ListComponentTypesPublisher.this.client.listComponentTypes(ListComponentTypesPublisher.this.firstRequest);
            }
            return ListComponentTypesPublisher.this.client.listComponentTypes((ListComponentTypesRequest)((Object)ListComponentTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

