/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListMetadataTransferJobsResponse;

public class ListMetadataTransferJobsIterable
implements SdkIterable<ListMetadataTransferJobsResponse> {
    private final IoTTwinMakerClient client;
    private final ListMetadataTransferJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetadataTransferJobsIterable(IoTTwinMakerClient client, ListMetadataTransferJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetadataTransferJobsResponseFetcher();
    }

    public Iterator<ListMetadataTransferJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMetadataTransferJobsResponseFetcher
    implements SyncPageFetcher<ListMetadataTransferJobsResponse> {
        private ListMetadataTransferJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetadataTransferJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetadataTransferJobsResponse nextPage(ListMetadataTransferJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMetadataTransferJobsIterable.this.client.listMetadataTransferJobs(ListMetadataTransferJobsIterable.this.firstRequest);
            }
            return ListMetadataTransferJobsIterable.this.client.listMetadataTransferJobs((ListMetadataTransferJobsRequest)((Object)ListMetadataTransferJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

