/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationVpcConfigurationResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationVpcConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(AddApplicationVpcConfigurationResponse.getter(AddApplicationVpcConfigurationResponse::applicationARN)).setter(AddApplicationVpcConfigurationResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(AddApplicationVpcConfigurationResponse.getter(AddApplicationVpcConfigurationResponse::applicationVersionId)).setter(AddApplicationVpcConfigurationResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<VpcConfigurationDescription> VPC_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfigurationDescription").getter(AddApplicationVpcConfigurationResponse.getter(AddApplicationVpcConfigurationResponse::vpcConfigurationDescription)).setter(AddApplicationVpcConfigurationResponse.setter(Builder::vpcConfigurationDescription)).constructor(VpcConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescription").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(AddApplicationVpcConfigurationResponse.getter(AddApplicationVpcConfigurationResponse::operationId)).setter(AddApplicationVpcConfigurationResponse.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, VPC_CONFIGURATION_DESCRIPTION_FIELD, OPERATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddApplicationVpcConfigurationResponse.memberNameToFieldInitializer();
    private final String applicationARN;
    private final Long applicationVersionId;
    private final VpcConfigurationDescription vpcConfigurationDescription;
    private final String operationId;

    private AddApplicationVpcConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.vpcConfigurationDescription = builder.vpcConfigurationDescription;
        this.operationId = builder.operationId;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final VpcConfigurationDescription vpcConfigurationDescription() {
        return this.vpcConfigurationDescription;
    }

    public final String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationVpcConfigurationResponse)) {
            return false;
        }
        AddApplicationVpcConfigurationResponse other = (AddApplicationVpcConfigurationResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.vpcConfigurationDescription(), other.vpcConfigurationDescription()) && Objects.equals(this.operationId(), other.operationId());
    }

    public final String toString() {
        return ToString.builder((String)"AddApplicationVpcConfigurationResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("VpcConfigurationDescription", (Object)this.vpcConfigurationDescription()).add("OperationId", (Object)this.operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "VpcConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationDescription()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("VpcConfigurationDescription", VPC_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationVpcConfigurationResponse, T> g) {
        return obj -> g.apply((AddApplicationVpcConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private VpcConfigurationDescription vpcConfigurationDescription;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationVpcConfigurationResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.vpcConfigurationDescription(model.vpcConfigurationDescription);
            this.operationId(model.operationId);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final VpcConfigurationDescription.Builder getVpcConfigurationDescription() {
            return this.vpcConfigurationDescription != null ? this.vpcConfigurationDescription.toBuilder() : null;
        }

        public final void setVpcConfigurationDescription(VpcConfigurationDescription.BuilderImpl vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription != null ? vpcConfigurationDescription.build() : null;
        }

        @Override
        public final Builder vpcConfigurationDescription(VpcConfigurationDescription vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public AddApplicationVpcConfigurationResponse build() {
            return new AddApplicationVpcConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationVpcConfigurationResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder vpcConfigurationDescription(VpcConfigurationDescription var1);

        default public Builder vpcConfigurationDescription(Consumer<VpcConfigurationDescription.Builder> vpcConfigurationDescription) {
            return this.vpcConfigurationDescription((VpcConfigurationDescription)((VpcConfigurationDescription.Builder)VpcConfigurationDescription.builder().applyMutation(vpcConfigurationDescription)).build());
        }

        public Builder operationId(String var1);
    }
}

