/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationMaintenanceConfigurationRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(UpdateApplicationMaintenanceConfigurationRequest.getter(UpdateApplicationMaintenanceConfigurationRequest::applicationName)).setter(UpdateApplicationMaintenanceConfigurationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<ApplicationMaintenanceConfigurationUpdate> APPLICATION_MAINTENANCE_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationMaintenanceConfigurationUpdate").getter(UpdateApplicationMaintenanceConfigurationRequest.getter(UpdateApplicationMaintenanceConfigurationRequest::applicationMaintenanceConfigurationUpdate)).setter(UpdateApplicationMaintenanceConfigurationRequest.setter(Builder::applicationMaintenanceConfigurationUpdate)).constructor(ApplicationMaintenanceConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMaintenanceConfigurationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_MAINTENANCE_CONFIGURATION_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationMaintenanceConfigurationRequest.memberNameToFieldInitializer();
    private final String applicationName;
    private final ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate;

    private UpdateApplicationMaintenanceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationMaintenanceConfigurationUpdate = builder.applicationMaintenanceConfigurationUpdate;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate() {
        return this.applicationMaintenanceConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMaintenanceConfigurationUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationMaintenanceConfigurationRequest)) {
            return false;
        }
        UpdateApplicationMaintenanceConfigurationRequest other = (UpdateApplicationMaintenanceConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationMaintenanceConfigurationUpdate(), other.applicationMaintenanceConfigurationUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationMaintenanceConfigurationRequest").add("ApplicationName", (Object)this.applicationName()).add("ApplicationMaintenanceConfigurationUpdate", (Object)this.applicationMaintenanceConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationMaintenanceConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationMaintenanceConfigurationUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("ApplicationMaintenanceConfigurationUpdate", APPLICATION_MAINTENANCE_CONFIGURATION_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationMaintenanceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationMaintenanceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationMaintenanceConfigurationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.applicationMaintenanceConfigurationUpdate(model.applicationMaintenanceConfigurationUpdate);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final ApplicationMaintenanceConfigurationUpdate.Builder getApplicationMaintenanceConfigurationUpdate() {
            return this.applicationMaintenanceConfigurationUpdate != null ? this.applicationMaintenanceConfigurationUpdate.toBuilder() : null;
        }

        public final void setApplicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate.BuilderImpl applicationMaintenanceConfigurationUpdate) {
            this.applicationMaintenanceConfigurationUpdate = applicationMaintenanceConfigurationUpdate != null ? applicationMaintenanceConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder applicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate applicationMaintenanceConfigurationUpdate) {
            this.applicationMaintenanceConfigurationUpdate = applicationMaintenanceConfigurationUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationMaintenanceConfigurationRequest build() {
            return new UpdateApplicationMaintenanceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationMaintenanceConfigurationUpdate(ApplicationMaintenanceConfigurationUpdate var1);

        default public Builder applicationMaintenanceConfigurationUpdate(Consumer<ApplicationMaintenanceConfigurationUpdate.Builder> applicationMaintenanceConfigurationUpdate) {
            return this.applicationMaintenanceConfigurationUpdate((ApplicationMaintenanceConfigurationUpdate)((ApplicationMaintenanceConfigurationUpdate.Builder)ApplicationMaintenanceConfigurationUpdate.builder().applyMutation(applicationMaintenanceConfigurationUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

