/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessorType {
    BILLING_TOKEN("BILLING_TOKEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessorType> VALUE_MAP;
    private final String value;

    private AccessorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessorType> knownValues() {
        EnumSet<AccessorType> knownValues = EnumSet.allOf(AccessorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessorType.class, AccessorType::toString);
    }
}

