/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StateDBType {
    LEVEL_DB("LevelDB"),
    COUCH_DB("CouchDB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateDBType> VALUE_MAP;
    private final String value;

    private StateDBType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateDBType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateDBType> knownValues() {
        EnumSet<StateDBType> knownValues = EnumSet.allOf(StateDBType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StateDBType.class, StateDBType::toString);
    }
}

