/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VoteValue {
    YES("YES"),
    NO("NO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VoteValue> VALUE_MAP;
    private final String value;

    private VoteValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VoteValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VoteValue> knownValues() {
        EnumSet<VoteValue> knownValues = EnumSet.allOf(VoteValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VoteValue.class, VoteValue::toString);
    }
}

