/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.ScheduleItem;
import software.amazon.awssdk.services.marketplaceagreement.model.ScheduleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PaymentScheduleTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PaymentScheduleTerm> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PaymentScheduleTerm.getter(PaymentScheduleTerm::type)).setter(PaymentScheduleTerm.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(PaymentScheduleTerm.getter(PaymentScheduleTerm::currencyCode)).setter(PaymentScheduleTerm.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<List<ScheduleItem>> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schedule").getter(PaymentScheduleTerm.getter(PaymentScheduleTerm::schedule)).setter(PaymentScheduleTerm.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduleItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CURRENCY_CODE_FIELD, SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PaymentScheduleTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String currencyCode;
    private final List<ScheduleItem> schedule;

    private PaymentScheduleTerm(BuilderImpl builder) {
        this.type = builder.type;
        this.currencyCode = builder.currencyCode;
        this.schedule = builder.schedule;
    }

    public final String type() {
        return this.type;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final boolean hasSchedule() {
        return this.schedule != null && !(this.schedule instanceof SdkAutoConstructList);
    }

    public final List<ScheduleItem> schedule() {
        return this.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchedule() ? this.schedule() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentScheduleTerm)) {
            return false;
        }
        PaymentScheduleTerm other = (PaymentScheduleTerm)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.currencyCode(), other.currencyCode()) && this.hasSchedule() == other.hasSchedule() && Objects.equals(this.schedule(), other.schedule());
    }

    public final String toString() {
        return ToString.builder((String)"PaymentScheduleTerm").add("Type", (Object)this.type()).add("CurrencyCode", (Object)this.currencyCode()).add("Schedule", this.hasSchedule() ? this.schedule() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaymentScheduleTerm, T> g) {
        return obj -> g.apply((PaymentScheduleTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String currencyCode;
        private List<ScheduleItem> schedule = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PaymentScheduleTerm model) {
            this.type(model.type);
            this.currencyCode(model.currencyCode);
            this.schedule(model.schedule);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<ScheduleItem.Builder> getSchedule() {
            List<ScheduleItem.Builder> result = ScheduleListCopier.copyToBuilder(this.schedule);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedule(Collection<ScheduleItem.BuilderImpl> schedule) {
            this.schedule = ScheduleListCopier.copyFromBuilder(schedule);
        }

        @Override
        public final Builder schedule(Collection<ScheduleItem> schedule) {
            this.schedule = ScheduleListCopier.copy(schedule);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedule(ScheduleItem ... schedule) {
            this.schedule(Arrays.asList(schedule));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedule(Consumer<ScheduleItem.Builder> ... schedule) {
            this.schedule(Stream.of(schedule).map(c -> (ScheduleItem)((ScheduleItem.Builder)ScheduleItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PaymentScheduleTerm build() {
            return new PaymentScheduleTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PaymentScheduleTerm> {
        public Builder type(String var1);

        public Builder currencyCode(String var1);

        public Builder schedule(Collection<ScheduleItem> var1);

        public Builder schedule(ScheduleItem ... var1);

        public Builder schedule(Consumer<ScheduleItem.Builder> ... var1);
    }
}

