/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityRequestListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeEntitiesRequest
extends MarketplaceCatalogRequest
implements ToCopyableBuilder<Builder, BatchDescribeEntitiesRequest> {
    private static final SdkField<List<EntityRequest>> ENTITY_REQUEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityRequestList").getter(BatchDescribeEntitiesRequest.getter(BatchDescribeEntitiesRequest::entityRequestList)).setter(BatchDescribeEntitiesRequest.setter(Builder::entityRequestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRequestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_REQUEST_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDescribeEntitiesRequest.memberNameToFieldInitializer();
    private final List<EntityRequest> entityRequestList;

    private BatchDescribeEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.entityRequestList = builder.entityRequestList;
    }

    public final boolean hasEntityRequestList() {
        return this.entityRequestList != null && !(this.entityRequestList instanceof SdkAutoConstructList);
    }

    public final List<EntityRequest> entityRequestList() {
        return this.entityRequestList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityRequestList() ? this.entityRequestList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeEntitiesRequest)) {
            return false;
        }
        BatchDescribeEntitiesRequest other = (BatchDescribeEntitiesRequest)((Object)obj);
        return this.hasEntityRequestList() == other.hasEntityRequestList() && Objects.equals(this.entityRequestList(), other.entityRequestList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeEntitiesRequest").add("EntityRequestList", this.hasEntityRequestList() ? this.entityRequestList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityRequestList": {
                return Optional.ofNullable(clazz.cast(this.entityRequestList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EntityRequest>>> map = new HashMap<String, SdkField<List<EntityRequest>>>();
        map.put("EntityRequestList", ENTITY_REQUEST_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeEntitiesRequest, T> g) {
        return obj -> g.apply((BatchDescribeEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogRequest.BuilderImpl
    implements Builder {
        private List<EntityRequest> entityRequestList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeEntitiesRequest model) {
            super(model);
            this.entityRequestList(model.entityRequestList);
        }

        public final List<EntityRequest.Builder> getEntityRequestList() {
            List<EntityRequest.Builder> result = EntityRequestListCopier.copyToBuilder(this.entityRequestList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityRequestList(Collection<EntityRequest.BuilderImpl> entityRequestList) {
            this.entityRequestList = EntityRequestListCopier.copyFromBuilder(entityRequestList);
        }

        @Override
        public final Builder entityRequestList(Collection<EntityRequest> entityRequestList) {
            this.entityRequestList = EntityRequestListCopier.copy(entityRequestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRequestList(EntityRequest ... entityRequestList) {
            this.entityRequestList(Arrays.asList(entityRequestList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRequestList(Consumer<EntityRequest.Builder> ... entityRequestList) {
            this.entityRequestList(Stream.of(entityRequestList).map(c -> (EntityRequest)((EntityRequest.Builder)EntityRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDescribeEntitiesRequest build() {
            return new BatchDescribeEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeEntitiesRequest> {
        public Builder entityRequestList(Collection<EntityRequest> var1);

        public Builder entityRequestList(EntityRequest ... var1);

        public Builder entityRequestList(Consumer<EntityRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

