/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacecatalog.model.BatchDescribeErrorDetail;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityDetail;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityDetailsCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.ErrorsCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeEntitiesResponse
extends MarketplaceCatalogResponse
implements ToCopyableBuilder<Builder, BatchDescribeEntitiesResponse> {
    private static final SdkField<Map<String, EntityDetail>> ENTITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EntityDetails").getter(BatchDescribeEntitiesResponse.getter(BatchDescribeEntitiesResponse::entityDetails)).setter(BatchDescribeEntitiesResponse.setter(Builder::entityDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, BatchDescribeErrorDetail>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Errors").getter(BatchDescribeEntitiesResponse.getter(BatchDescribeEntitiesResponse::errors)).setter(BatchDescribeEntitiesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDescribeErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_DETAILS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDescribeEntitiesResponse.memberNameToFieldInitializer();
    private final Map<String, EntityDetail> entityDetails;
    private final Map<String, BatchDescribeErrorDetail> errors;

    private BatchDescribeEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entityDetails = builder.entityDetails;
        this.errors = builder.errors;
    }

    public final boolean hasEntityDetails() {
        return this.entityDetails != null && !(this.entityDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, EntityDetail> entityDetails() {
        return this.entityDetails;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructMap);
    }

    public final Map<String, BatchDescribeErrorDetail> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityDetails() ? this.entityDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeEntitiesResponse)) {
            return false;
        }
        BatchDescribeEntitiesResponse other = (BatchDescribeEntitiesResponse)((Object)obj);
        return this.hasEntityDetails() == other.hasEntityDetails() && Objects.equals(this.entityDetails(), other.entityDetails()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeEntitiesResponse").add("EntityDetails", this.hasEntityDetails() ? this.entityDetails() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityDetails": {
                return Optional.ofNullable(clazz.cast(this.entityDetails()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityDetails", ENTITY_DETAILS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeEntitiesResponse, T> g) {
        return obj -> g.apply((BatchDescribeEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogResponse.BuilderImpl
    implements Builder {
        private Map<String, EntityDetail> entityDetails = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, BatchDescribeErrorDetail> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeEntitiesResponse model) {
            super(model);
            this.entityDetails(model.entityDetails);
            this.errors(model.errors);
        }

        public final Map<String, EntityDetail.Builder> getEntityDetails() {
            Map<String, EntityDetail.Builder> result = EntityDetailsCopier.copyToBuilder(this.entityDetails);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEntityDetails(Map<String, EntityDetail.BuilderImpl> entityDetails) {
            this.entityDetails = EntityDetailsCopier.copyFromBuilder(entityDetails);
        }

        @Override
        public final Builder entityDetails(Map<String, EntityDetail> entityDetails) {
            this.entityDetails = EntityDetailsCopier.copy(entityDetails);
            return this;
        }

        public final Map<String, BatchDescribeErrorDetail.Builder> getErrors() {
            Map<String, BatchDescribeErrorDetail.Builder> result = ErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setErrors(Map<String, BatchDescribeErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Map<String, BatchDescribeErrorDetail> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        public BatchDescribeEntitiesResponse build() {
            return new BatchDescribeEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeEntitiesResponse> {
        public Builder entityDetails(Map<String, EntityDetail> var1);

        public Builder errors(Map<String, BatchDescribeErrorDetail> var1);
    }
}

