/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeStatus;
import software.amazon.awssdk.services.marketplacecatalog.model.FailureCode;
import software.amazon.awssdk.services.marketplacecatalog.model.ResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSetSummaryListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSetSummaryListItem> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::changeSetId)).setter(ChangeSetSummaryListItem.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<String> CHANGE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetArn").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::changeSetArn)).setter(ChangeSetSummaryListItem.setter(Builder::changeSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetArn").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::changeSetName)).setter(ChangeSetSummaryListItem.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::startTime)).setter(ChangeSetSummaryListItem.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::endTime)).setter(ChangeSetSummaryListItem.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::statusAsString)).setter(ChangeSetSummaryListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> ENTITY_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityIdList").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::entityIdList)).setter(ChangeSetSummaryListItem.setter(Builder::entityIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(ChangeSetSummaryListItem.getter(ChangeSetSummaryListItem::failureCodeAsString)).setter(ChangeSetSummaryListItem.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD, CHANGE_SET_ARN_FIELD, CHANGE_SET_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ENTITY_ID_LIST_FIELD, FAILURE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSetSummaryListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changeSetId;
    private final String changeSetArn;
    private final String changeSetName;
    private final String startTime;
    private final String endTime;
    private final String status;
    private final List<String> entityIdList;
    private final String failureCode;

    private ChangeSetSummaryListItem(BuilderImpl builder) {
        this.changeSetId = builder.changeSetId;
        this.changeSetArn = builder.changeSetArn;
        this.changeSetName = builder.changeSetName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.entityIdList = builder.entityIdList;
        this.failureCode = builder.failureCode;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final String changeSetArn() {
        return this.changeSetArn;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final ChangeStatus status() {
        return ChangeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasEntityIdList() {
        return this.entityIdList != null && !(this.entityIdList instanceof SdkAutoConstructList);
    }

    public final List<String> entityIdList() {
        return this.entityIdList;
    }

    public final FailureCode failureCode() {
        return FailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityIdList() ? this.entityIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummaryListItem)) {
            return false;
        }
        ChangeSetSummaryListItem other = (ChangeSetSummaryListItem)obj;
        return Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.changeSetArn(), other.changeSetArn()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasEntityIdList() == other.hasEntityIdList() && Objects.equals(this.entityIdList(), other.entityIdList()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSetSummaryListItem").add("ChangeSetId", (Object)this.changeSetId()).add("ChangeSetArn", (Object)this.changeSetArn()).add("ChangeSetName", (Object)this.changeSetName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("EntityIdList", this.hasEntityIdList() ? this.entityIdList() : null).add("FailureCode", (Object)this.failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "ChangeSetArn": {
                return Optional.ofNullable(clazz.cast(this.changeSetArn()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EntityIdList": {
                return Optional.ofNullable(clazz.cast(this.entityIdList()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("ChangeSetArn", CHANGE_SET_ARN_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EntityIdList", ENTITY_ID_LIST_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetSummaryListItem, T> g) {
        return obj -> g.apply((ChangeSetSummaryListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeSetId;
        private String changeSetArn;
        private String changeSetName;
        private String startTime;
        private String endTime;
        private String status;
        private List<String> entityIdList = DefaultSdkAutoConstructList.getInstance();
        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummaryListItem model) {
            this.changeSetId(model.changeSetId);
            this.changeSetArn(model.changeSetArn);
            this.changeSetName(model.changeSetName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.entityIdList(model.entityIdList);
            this.failureCode(model.failureCode);
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetArn() {
            return this.changeSetArn;
        }

        public final void setChangeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
        }

        @Override
        public final Builder changeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getEntityIdList() {
            if (this.entityIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityIdList;
        }

        public final void setEntityIdList(Collection<String> entityIdList) {
            this.entityIdList = ResourceIdListCopier.copy(entityIdList);
        }

        @Override
        public final Builder entityIdList(Collection<String> entityIdList) {
            this.entityIdList = ResourceIdListCopier.copy(entityIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIdList(String ... entityIdList) {
            this.entityIdList(Arrays.asList(entityIdList));
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public ChangeSetSummaryListItem build() {
            return new ChangeSetSummaryListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSetSummaryListItem> {
        public Builder changeSetId(String var1);

        public Builder changeSetArn(String var1);

        public Builder changeSetName(String var1);

        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder status(String var1);

        public Builder status(ChangeStatus var1);

        public Builder entityIdList(Collection<String> var1);

        public Builder entityIdList(String ... var1);

        public Builder failureCode(String var1);

        public Builder failureCode(FailureCode var1);
    }
}

