/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.Entity;
import software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetail;
import software.amazon.awssdk.services.marketplacecatalog.model.ErrorDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSummary> {
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeType").getter(ChangeSummary.getter(ChangeSummary::changeType)).setter(ChangeSummary.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()}).build();
    private static final SdkField<Entity> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entity").getter(ChangeSummary.getter(ChangeSummary::entity)).setter(ChangeSummary.setter(Builder::entity)).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Details").getter(ChangeSummary.getter(ChangeSummary::details)).setter(ChangeSummary.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<Document> DETAILS_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("DetailsDocument").getter(ChangeSummary.getter(ChangeSummary::detailsDocument)).setter(ChangeSummary.setter(Builder::detailsDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailsDocument").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetailList").getter(ChangeSummary.getter(ChangeSummary::errorDetailList)).setter(ChangeSummary.setter(Builder::errorDetailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeName").getter(ChangeSummary.getter(ChangeSummary::changeName)).setter(ChangeSummary.setter(Builder::changeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_FIELD, ENTITY_FIELD, DETAILS_FIELD, DETAILS_DOCUMENT_FIELD, ERROR_DETAIL_LIST_FIELD, CHANGE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changeType;
    private final Entity entity;
    private final String details;
    private final Document detailsDocument;
    private final List<ErrorDetail> errorDetailList;
    private final String changeName;

    private ChangeSummary(BuilderImpl builder) {
        this.changeType = builder.changeType;
        this.entity = builder.entity;
        this.details = builder.details;
        this.detailsDocument = builder.detailsDocument;
        this.errorDetailList = builder.errorDetailList;
        this.changeName = builder.changeName;
    }

    public final String changeType() {
        return this.changeType;
    }

    public final Entity entity() {
        return this.entity;
    }

    public final String details() {
        return this.details;
    }

    public final Document detailsDocument() {
        return this.detailsDocument;
    }

    public final boolean hasErrorDetailList() {
        return this.errorDetailList != null && !(this.errorDetailList instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errorDetailList() {
        return this.errorDetailList;
    }

    public final String changeName() {
        return this.changeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entity());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailsDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetailList() ? this.errorDetailList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSummary)) {
            return false;
        }
        ChangeSummary other = (ChangeSummary)obj;
        return Objects.equals(this.changeType(), other.changeType()) && Objects.equals(this.entity(), other.entity()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.detailsDocument(), other.detailsDocument()) && this.hasErrorDetailList() == other.hasErrorDetailList() && Objects.equals(this.errorDetailList(), other.errorDetailList()) && Objects.equals(this.changeName(), other.changeName());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSummary").add("ChangeType", (Object)this.changeType()).add("Entity", (Object)this.entity()).add("Details", (Object)this.details()).add("DetailsDocument", (Object)this.detailsDocument()).add("ErrorDetailList", this.hasErrorDetailList() ? this.errorDetailList() : null).add("ChangeName", (Object)this.changeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeType": {
                return Optional.ofNullable(clazz.cast(this.changeType()));
            }
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entity()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "DetailsDocument": {
                return Optional.ofNullable(clazz.cast(this.detailsDocument()));
            }
            case "ErrorDetailList": {
                return Optional.ofNullable(clazz.cast(this.errorDetailList()));
            }
            case "ChangeName": {
                return Optional.ofNullable(clazz.cast(this.changeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChangeType", CHANGE_TYPE_FIELD);
        map.put("Entity", ENTITY_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("DetailsDocument", DETAILS_DOCUMENT_FIELD);
        map.put("ErrorDetailList", ERROR_DETAIL_LIST_FIELD);
        map.put("ChangeName", CHANGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSummary, T> g) {
        return obj -> g.apply((ChangeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeType;
        private Entity entity;
        private String details;
        private Document detailsDocument;
        private List<ErrorDetail> errorDetailList = DefaultSdkAutoConstructList.getInstance();
        private String changeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSummary model) {
            this.changeType(model.changeType);
            this.entity(model.entity);
            this.details(model.details);
            this.detailsDocument(model.detailsDocument);
            this.errorDetailList(model.errorDetailList);
            this.changeName(model.changeName);
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        public final Entity.Builder getEntity() {
            return this.entity != null ? this.entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final String getDetails() {
            return this.details;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final Document getDetailsDocument() {
            return this.detailsDocument;
        }

        public final void setDetailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
        }

        @Override
        public final Builder detailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetailList() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.errorDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetailList(Collection<ErrorDetail.BuilderImpl> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copyFromBuilder(errorDetailList);
        }

        @Override
        public final Builder errorDetailList(Collection<ErrorDetail> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copy(errorDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(ErrorDetail ... errorDetailList) {
            this.errorDetailList(Arrays.asList(errorDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(Consumer<ErrorDetail.Builder> ... errorDetailList) {
            this.errorDetailList(Stream.of(errorDetailList).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeName() {
            return this.changeName;
        }

        public final void setChangeName(String changeName) {
            this.changeName = changeName;
        }

        @Override
        public final Builder changeName(String changeName) {
            this.changeName = changeName;
            return this;
        }

        public ChangeSummary build() {
            return new ChangeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSummary> {
        public Builder changeType(String var1);

        public Builder entity(Entity var1);

        default public Builder entity(Consumer<Entity.Builder> entity) {
            return this.entity((Entity)((Entity.Builder)Entity.builder().applyMutation(entity)).build());
        }

        public Builder details(String var1);

        public Builder detailsDocument(Document var1);

        public Builder errorDetailList(Collection<ErrorDetail> var1);

        public Builder errorDetailList(ErrorDetail ... var1);

        public Builder errorDetailList(Consumer<ErrorDetail.Builder> ... var1);

        public Builder changeName(String var1);
    }
}

