/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityDetail> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(EntityDetail.getter(EntityDetail::entityType)).setter(EntityDetail.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(EntityDetail.getter(EntityDetail::entityArn)).setter(EntityDetail.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityIdentifier").getter(EntityDetail.getter(EntityDetail::entityIdentifier)).setter(EntityDetail.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdentifier").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(EntityDetail.getter(EntityDetail::lastModifiedDate)).setter(EntityDetail.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<Document> DETAILS_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("DetailsDocument").getter(EntityDetail.getter(EntityDetail::detailsDocument)).setter(EntityDetail.setter(Builder::detailsDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailsDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD, ENTITY_ARN_FIELD, ENTITY_IDENTIFIER_FIELD, LAST_MODIFIED_DATE_FIELD, DETAILS_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntityDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entityType;
    private final String entityArn;
    private final String entityIdentifier;
    private final String lastModifiedDate;
    private final Document detailsDocument;

    private EntityDetail(BuilderImpl builder) {
        this.entityType = builder.entityType;
        this.entityArn = builder.entityArn;
        this.entityIdentifier = builder.entityIdentifier;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.detailsDocument = builder.detailsDocument;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Document detailsDocument() {
        return this.detailsDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailsDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetail)) {
            return false;
        }
        EntityDetail other = (EntityDetail)obj;
        return Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.detailsDocument(), other.detailsDocument());
    }

    public final String toString() {
        return ToString.builder((String)"EntityDetail").add("EntityType", (Object)this.entityType()).add("EntityArn", (Object)this.entityArn()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("DetailsDocument", (Object)this.detailsDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "EntityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "DetailsDocument": {
                return Optional.ofNullable(clazz.cast(this.detailsDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        map.put("EntityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("DetailsDocument", DETAILS_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntityDetail, T> g) {
        return obj -> g.apply((EntityDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityType;
        private String entityArn;
        private String entityIdentifier;
        private String lastModifiedDate;
        private Document detailsDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDetail model) {
            this.entityType(model.entityType);
            this.entityArn(model.entityArn);
            this.entityIdentifier(model.entityIdentifier);
            this.lastModifiedDate(model.lastModifiedDate);
            this.detailsDocument(model.detailsDocument);
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Document getDetailsDocument() {
            return this.detailsDocument;
        }

        public final void setDetailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
        }

        @Override
        public final Builder detailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
            return this;
        }

        public EntityDetail build() {
            return new EntityDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityDetail> {
        public Builder entityType(String var1);

        public Builder entityArn(String var1);

        public Builder entityIdentifier(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder detailsDocument(Document var1);
    }
}

