/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.MachineLearningProductSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferSetSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.ResaleAuthorizationSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitySummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EntitySummary.getter(EntitySummary::name)).setter(EntitySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(EntitySummary.getter(EntitySummary::entityType)).setter(EntitySummary.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(EntitySummary.getter(EntitySummary::entityId)).setter(EntitySummary.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(EntitySummary.getter(EntitySummary::entityArn)).setter(EntitySummary.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(EntitySummary.getter(EntitySummary::lastModifiedDate)).setter(EntitySummary.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(EntitySummary.getter(EntitySummary::visibility)).setter(EntitySummary.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<AmiProductSummary> AMI_PRODUCT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmiProductSummary").getter(EntitySummary.getter(EntitySummary::amiProductSummary)).setter(EntitySummary.setter(Builder::amiProductSummary)).constructor(AmiProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductSummary").build()}).build();
    private static final SdkField<ContainerProductSummary> CONTAINER_PRODUCT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerProductSummary").getter(EntitySummary.getter(EntitySummary::containerProductSummary)).setter(EntitySummary.setter(Builder::containerProductSummary)).constructor(ContainerProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductSummary").build()}).build();
    private static final SdkField<DataProductSummary> DATA_PRODUCT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProductSummary").getter(EntitySummary.getter(EntitySummary::dataProductSummary)).setter(EntitySummary.setter(Builder::dataProductSummary)).constructor(DataProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductSummary").build()}).build();
    private static final SdkField<SaaSProductSummary> SAA_S_PRODUCT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SaaSProductSummary").getter(EntitySummary.getter(EntitySummary::saaSProductSummary)).setter(EntitySummary.setter(Builder::saaSProductSummary)).constructor(SaaSProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductSummary").build()}).build();
    private static final SdkField<OfferSummary> OFFER_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfferSummary").getter(EntitySummary.getter(EntitySummary::offerSummary)).setter(EntitySummary.setter(Builder::offerSummary)).constructor(OfferSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferSummary").build()}).build();
    private static final SdkField<ResaleAuthorizationSummary> RESALE_AUTHORIZATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResaleAuthorizationSummary").getter(EntitySummary.getter(EntitySummary::resaleAuthorizationSummary)).setter(EntitySummary.setter(Builder::resaleAuthorizationSummary)).constructor(ResaleAuthorizationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationSummary").build()}).build();
    private static final SdkField<MachineLearningProductSummary> MACHINE_LEARNING_PRODUCT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MachineLearningProductSummary").getter(EntitySummary.getter(EntitySummary::machineLearningProductSummary)).setter(EntitySummary.setter(Builder::machineLearningProductSummary)).constructor(MachineLearningProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MachineLearningProductSummary").build()}).build();
    private static final SdkField<OfferSetSummary> OFFER_SET_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfferSetSummary").getter(EntitySummary.getter(EntitySummary::offerSetSummary)).setter(EntitySummary.setter(Builder::offerSetSummary)).constructor(OfferSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferSetSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENTITY_TYPE_FIELD, ENTITY_ID_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, VISIBILITY_FIELD, AMI_PRODUCT_SUMMARY_FIELD, CONTAINER_PRODUCT_SUMMARY_FIELD, DATA_PRODUCT_SUMMARY_FIELD, SAA_S_PRODUCT_SUMMARY_FIELD, OFFER_SUMMARY_FIELD, RESALE_AUTHORIZATION_SUMMARY_FIELD, MACHINE_LEARNING_PRODUCT_SUMMARY_FIELD, OFFER_SET_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String entityType;
    private final String entityId;
    private final String entityArn;
    private final String lastModifiedDate;
    private final String visibility;
    private final AmiProductSummary amiProductSummary;
    private final ContainerProductSummary containerProductSummary;
    private final DataProductSummary dataProductSummary;
    private final SaaSProductSummary saaSProductSummary;
    private final OfferSummary offerSummary;
    private final ResaleAuthorizationSummary resaleAuthorizationSummary;
    private final MachineLearningProductSummary machineLearningProductSummary;
    private final OfferSetSummary offerSetSummary;

    private EntitySummary(BuilderImpl builder) {
        this.name = builder.name;
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.visibility = builder.visibility;
        this.amiProductSummary = builder.amiProductSummary;
        this.containerProductSummary = builder.containerProductSummary;
        this.dataProductSummary = builder.dataProductSummary;
        this.saaSProductSummary = builder.saaSProductSummary;
        this.offerSummary = builder.offerSummary;
        this.resaleAuthorizationSummary = builder.resaleAuthorizationSummary;
        this.machineLearningProductSummary = builder.machineLearningProductSummary;
        this.offerSetSummary = builder.offerSetSummary;
    }

    public final String name() {
        return this.name;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String visibility() {
        return this.visibility;
    }

    public final AmiProductSummary amiProductSummary() {
        return this.amiProductSummary;
    }

    public final ContainerProductSummary containerProductSummary() {
        return this.containerProductSummary;
    }

    public final DataProductSummary dataProductSummary() {
        return this.dataProductSummary;
    }

    public final SaaSProductSummary saaSProductSummary() {
        return this.saaSProductSummary;
    }

    public final OfferSummary offerSummary() {
        return this.offerSummary;
    }

    public final ResaleAuthorizationSummary resaleAuthorizationSummary() {
        return this.resaleAuthorizationSummary;
    }

    public final MachineLearningProductSummary machineLearningProductSummary() {
        return this.machineLearningProductSummary;
    }

    public final OfferSetSummary offerSetSummary() {
        return this.offerSetSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.saaSProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.resaleAuthorizationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.machineLearningProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerSetSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.visibility(), other.visibility()) && Objects.equals(this.amiProductSummary(), other.amiProductSummary()) && Objects.equals(this.containerProductSummary(), other.containerProductSummary()) && Objects.equals(this.dataProductSummary(), other.dataProductSummary()) && Objects.equals(this.saaSProductSummary(), other.saaSProductSummary()) && Objects.equals(this.offerSummary(), other.offerSummary()) && Objects.equals(this.resaleAuthorizationSummary(), other.resaleAuthorizationSummary()) && Objects.equals(this.machineLearningProductSummary(), other.machineLearningProductSummary()) && Objects.equals(this.offerSetSummary(), other.offerSetSummary());
    }

    public final String toString() {
        return ToString.builder((String)"EntitySummary").add("Name", (Object)this.name()).add("EntityType", (Object)this.entityType()).add("EntityId", (Object)this.entityId()).add("EntityArn", (Object)this.entityArn()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Visibility", (Object)this.visibility()).add("AmiProductSummary", (Object)this.amiProductSummary()).add("ContainerProductSummary", (Object)this.containerProductSummary()).add("DataProductSummary", (Object)this.dataProductSummary()).add("SaaSProductSummary", (Object)this.saaSProductSummary()).add("OfferSummary", (Object)this.offerSummary()).add("ResaleAuthorizationSummary", (Object)this.resaleAuthorizationSummary()).add("MachineLearningProductSummary", (Object)this.machineLearningProductSummary()).add("OfferSetSummary", (Object)this.offerSetSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
            case "AmiProductSummary": {
                return Optional.ofNullable(clazz.cast(this.amiProductSummary()));
            }
            case "ContainerProductSummary": {
                return Optional.ofNullable(clazz.cast(this.containerProductSummary()));
            }
            case "DataProductSummary": {
                return Optional.ofNullable(clazz.cast(this.dataProductSummary()));
            }
            case "SaaSProductSummary": {
                return Optional.ofNullable(clazz.cast(this.saaSProductSummary()));
            }
            case "OfferSummary": {
                return Optional.ofNullable(clazz.cast(this.offerSummary()));
            }
            case "ResaleAuthorizationSummary": {
                return Optional.ofNullable(clazz.cast(this.resaleAuthorizationSummary()));
            }
            case "MachineLearningProductSummary": {
                return Optional.ofNullable(clazz.cast(this.machineLearningProductSummary()));
            }
            case "OfferSetSummary": {
                return Optional.ofNullable(clazz.cast(this.offerSetSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("AmiProductSummary", AMI_PRODUCT_SUMMARY_FIELD);
        map.put("ContainerProductSummary", CONTAINER_PRODUCT_SUMMARY_FIELD);
        map.put("DataProductSummary", DATA_PRODUCT_SUMMARY_FIELD);
        map.put("SaaSProductSummary", SAA_S_PRODUCT_SUMMARY_FIELD);
        map.put("OfferSummary", OFFER_SUMMARY_FIELD);
        map.put("ResaleAuthorizationSummary", RESALE_AUTHORIZATION_SUMMARY_FIELD);
        map.put("MachineLearningProductSummary", MACHINE_LEARNING_PRODUCT_SUMMARY_FIELD);
        map.put("OfferSetSummary", OFFER_SET_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String entityType;
        private String entityId;
        private String entityArn;
        private String lastModifiedDate;
        private String visibility;
        private AmiProductSummary amiProductSummary;
        private ContainerProductSummary containerProductSummary;
        private DataProductSummary dataProductSummary;
        private SaaSProductSummary saaSProductSummary;
        private OfferSummary offerSummary;
        private ResaleAuthorizationSummary resaleAuthorizationSummary;
        private MachineLearningProductSummary machineLearningProductSummary;
        private OfferSetSummary offerSetSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            this.name(model.name);
            this.entityType(model.entityType);
            this.entityId(model.entityId);
            this.entityArn(model.entityArn);
            this.lastModifiedDate(model.lastModifiedDate);
            this.visibility(model.visibility);
            this.amiProductSummary(model.amiProductSummary);
            this.containerProductSummary(model.containerProductSummary);
            this.dataProductSummary(model.dataProductSummary);
            this.saaSProductSummary(model.saaSProductSummary);
            this.offerSummary(model.offerSummary);
            this.resaleAuthorizationSummary(model.resaleAuthorizationSummary);
            this.machineLearningProductSummary(model.machineLearningProductSummary);
            this.offerSetSummary(model.offerSetSummary);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public final AmiProductSummary.Builder getAmiProductSummary() {
            return this.amiProductSummary != null ? this.amiProductSummary.toBuilder() : null;
        }

        public final void setAmiProductSummary(AmiProductSummary.BuilderImpl amiProductSummary) {
            this.amiProductSummary = amiProductSummary != null ? amiProductSummary.build() : null;
        }

        @Override
        public final Builder amiProductSummary(AmiProductSummary amiProductSummary) {
            this.amiProductSummary = amiProductSummary;
            return this;
        }

        public final ContainerProductSummary.Builder getContainerProductSummary() {
            return this.containerProductSummary != null ? this.containerProductSummary.toBuilder() : null;
        }

        public final void setContainerProductSummary(ContainerProductSummary.BuilderImpl containerProductSummary) {
            this.containerProductSummary = containerProductSummary != null ? containerProductSummary.build() : null;
        }

        @Override
        public final Builder containerProductSummary(ContainerProductSummary containerProductSummary) {
            this.containerProductSummary = containerProductSummary;
            return this;
        }

        public final DataProductSummary.Builder getDataProductSummary() {
            return this.dataProductSummary != null ? this.dataProductSummary.toBuilder() : null;
        }

        public final void setDataProductSummary(DataProductSummary.BuilderImpl dataProductSummary) {
            this.dataProductSummary = dataProductSummary != null ? dataProductSummary.build() : null;
        }

        @Override
        public final Builder dataProductSummary(DataProductSummary dataProductSummary) {
            this.dataProductSummary = dataProductSummary;
            return this;
        }

        public final SaaSProductSummary.Builder getSaaSProductSummary() {
            return this.saaSProductSummary != null ? this.saaSProductSummary.toBuilder() : null;
        }

        public final void setSaaSProductSummary(SaaSProductSummary.BuilderImpl saaSProductSummary) {
            this.saaSProductSummary = saaSProductSummary != null ? saaSProductSummary.build() : null;
        }

        @Override
        public final Builder saaSProductSummary(SaaSProductSummary saaSProductSummary) {
            this.saaSProductSummary = saaSProductSummary;
            return this;
        }

        public final OfferSummary.Builder getOfferSummary() {
            return this.offerSummary != null ? this.offerSummary.toBuilder() : null;
        }

        public final void setOfferSummary(OfferSummary.BuilderImpl offerSummary) {
            this.offerSummary = offerSummary != null ? offerSummary.build() : null;
        }

        @Override
        public final Builder offerSummary(OfferSummary offerSummary) {
            this.offerSummary = offerSummary;
            return this;
        }

        public final ResaleAuthorizationSummary.Builder getResaleAuthorizationSummary() {
            return this.resaleAuthorizationSummary != null ? this.resaleAuthorizationSummary.toBuilder() : null;
        }

        public final void setResaleAuthorizationSummary(ResaleAuthorizationSummary.BuilderImpl resaleAuthorizationSummary) {
            this.resaleAuthorizationSummary = resaleAuthorizationSummary != null ? resaleAuthorizationSummary.build() : null;
        }

        @Override
        public final Builder resaleAuthorizationSummary(ResaleAuthorizationSummary resaleAuthorizationSummary) {
            this.resaleAuthorizationSummary = resaleAuthorizationSummary;
            return this;
        }

        public final MachineLearningProductSummary.Builder getMachineLearningProductSummary() {
            return this.machineLearningProductSummary != null ? this.machineLearningProductSummary.toBuilder() : null;
        }

        public final void setMachineLearningProductSummary(MachineLearningProductSummary.BuilderImpl machineLearningProductSummary) {
            this.machineLearningProductSummary = machineLearningProductSummary != null ? machineLearningProductSummary.build() : null;
        }

        @Override
        public final Builder machineLearningProductSummary(MachineLearningProductSummary machineLearningProductSummary) {
            this.machineLearningProductSummary = machineLearningProductSummary;
            return this;
        }

        public final OfferSetSummary.Builder getOfferSetSummary() {
            return this.offerSetSummary != null ? this.offerSetSummary.toBuilder() : null;
        }

        public final void setOfferSetSummary(OfferSetSummary.BuilderImpl offerSetSummary) {
            this.offerSetSummary = offerSetSummary != null ? offerSetSummary.build() : null;
        }

        @Override
        public final Builder offerSetSummary(OfferSetSummary offerSetSummary) {
            this.offerSetSummary = offerSetSummary;
            return this;
        }

        public EntitySummary build() {
            return new EntitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitySummary> {
        public Builder name(String var1);

        public Builder entityType(String var1);

        public Builder entityId(String var1);

        public Builder entityArn(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder visibility(String var1);

        public Builder amiProductSummary(AmiProductSummary var1);

        default public Builder amiProductSummary(Consumer<AmiProductSummary.Builder> amiProductSummary) {
            return this.amiProductSummary((AmiProductSummary)((AmiProductSummary.Builder)AmiProductSummary.builder().applyMutation(amiProductSummary)).build());
        }

        public Builder containerProductSummary(ContainerProductSummary var1);

        default public Builder containerProductSummary(Consumer<ContainerProductSummary.Builder> containerProductSummary) {
            return this.containerProductSummary((ContainerProductSummary)((ContainerProductSummary.Builder)ContainerProductSummary.builder().applyMutation(containerProductSummary)).build());
        }

        public Builder dataProductSummary(DataProductSummary var1);

        default public Builder dataProductSummary(Consumer<DataProductSummary.Builder> dataProductSummary) {
            return this.dataProductSummary((DataProductSummary)((DataProductSummary.Builder)DataProductSummary.builder().applyMutation(dataProductSummary)).build());
        }

        public Builder saaSProductSummary(SaaSProductSummary var1);

        default public Builder saaSProductSummary(Consumer<SaaSProductSummary.Builder> saaSProductSummary) {
            return this.saaSProductSummary((SaaSProductSummary)((SaaSProductSummary.Builder)SaaSProductSummary.builder().applyMutation(saaSProductSummary)).build());
        }

        public Builder offerSummary(OfferSummary var1);

        default public Builder offerSummary(Consumer<OfferSummary.Builder> offerSummary) {
            return this.offerSummary((OfferSummary)((OfferSummary.Builder)OfferSummary.builder().applyMutation(offerSummary)).build());
        }

        public Builder resaleAuthorizationSummary(ResaleAuthorizationSummary var1);

        default public Builder resaleAuthorizationSummary(Consumer<ResaleAuthorizationSummary.Builder> resaleAuthorizationSummary) {
            return this.resaleAuthorizationSummary((ResaleAuthorizationSummary)((ResaleAuthorizationSummary.Builder)ResaleAuthorizationSummary.builder().applyMutation(resaleAuthorizationSummary)).build());
        }

        public Builder machineLearningProductSummary(MachineLearningProductSummary var1);

        default public Builder machineLearningProductSummary(Consumer<MachineLearningProductSummary.Builder> machineLearningProductSummary) {
            return this.machineLearningProductSummary((MachineLearningProductSummary)((MachineLearningProductSummary.Builder)MachineLearningProductSummary.builder().applyMutation(machineLearningProductSummary)).build());
        }

        public Builder offerSetSummary(OfferSetSummary var1);

        default public Builder offerSetSummary(Consumer<OfferSetSummary.Builder> offerSetSummary) {
            return this.offerSetSummary((OfferSetSummary)((OfferSetSummary.Builder)OfferSetSummary.builder().applyMutation(offerSetSummary)).build());
        }
    }
}

