/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityTypeFilters;
import software.amazon.awssdk.services.marketplacecatalog.model.EntityTypeSort;
import software.amazon.awssdk.services.marketplacecatalog.model.Filter;
import software.amazon.awssdk.services.marketplacecatalog.model.FilterListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.OwnershipType;
import software.amazon.awssdk.services.marketplacecatalog.model.Sort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesRequest
extends MarketplaceCatalogRequest
implements ToCopyableBuilder<Builder, ListEntitiesRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEntitiesRequest.getter(ListEntitiesRequest::catalog)).setter(ListEntitiesRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(ListEntitiesRequest.getter(ListEntitiesRequest::entityType)).setter(ListEntitiesRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<List<Filter>> FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterList").getter(ListEntitiesRequest.getter(ListEntitiesRequest::filterList)).setter(ListEntitiesRequest.setter(Builder::filterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Sort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEntitiesRequest.getter(ListEntitiesRequest::sort)).setter(ListEntitiesRequest.setter(Builder::sort)).constructor(Sort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntitiesRequest.getter(ListEntitiesRequest::nextToken)).setter(ListEntitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEntitiesRequest.getter(ListEntitiesRequest::maxResults)).setter(ListEntitiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> OWNERSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnershipType").getter(ListEntitiesRequest.getter(ListEntitiesRequest::ownershipTypeAsString)).setter(ListEntitiesRequest.setter(Builder::ownershipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipType").build()}).build();
    private static final SdkField<EntityTypeFilters> ENTITY_TYPE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityTypeFilters").getter(ListEntitiesRequest.getter(ListEntitiesRequest::entityTypeFilters)).setter(ListEntitiesRequest.setter(Builder::entityTypeFilters)).constructor(EntityTypeFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypeFilters").build()}).build();
    private static final SdkField<EntityTypeSort> ENTITY_TYPE_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityTypeSort").getter(ListEntitiesRequest.getter(ListEntitiesRequest::entityTypeSort)).setter(ListEntitiesRequest.setter(Builder::entityTypeSort)).constructor(EntityTypeSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypeSort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ENTITY_TYPE_FIELD, FILTER_LIST_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, OWNERSHIP_TYPE_FIELD, ENTITY_TYPE_FILTERS_FIELD, ENTITY_TYPE_SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntitiesRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String entityType;
    private final List<Filter> filterList;
    private final Sort sort;
    private final String nextToken;
    private final Integer maxResults;
    private final String ownershipType;
    private final EntityTypeFilters entityTypeFilters;
    private final EntityTypeSort entityTypeSort;

    private ListEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.entityType = builder.entityType;
        this.filterList = builder.filterList;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.ownershipType = builder.ownershipType;
        this.entityTypeFilters = builder.entityTypeFilters;
        this.entityTypeSort = builder.entityTypeSort;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final boolean hasFilterList() {
        return this.filterList != null && !(this.filterList instanceof SdkAutoConstructList);
    }

    public final List<Filter> filterList() {
        return this.filterList;
    }

    public final Sort sort() {
        return this.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final OwnershipType ownershipType() {
        return OwnershipType.fromValue(this.ownershipType);
    }

    public final String ownershipTypeAsString() {
        return this.ownershipType;
    }

    public final EntityTypeFilters entityTypeFilters() {
        return this.entityTypeFilters;
    }

    public final EntityTypeSort entityTypeSort() {
        return this.entityTypeSort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterList() ? this.filterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeSort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesRequest)) {
            return false;
        }
        ListEntitiesRequest other = (ListEntitiesRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.entityType(), other.entityType()) && this.hasFilterList() == other.hasFilterList() && Objects.equals(this.filterList(), other.filterList()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.ownershipTypeAsString(), other.ownershipTypeAsString()) && Objects.equals(this.entityTypeFilters(), other.entityTypeFilters()) && Objects.equals(this.entityTypeSort(), other.entityTypeSort());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesRequest").add("Catalog", (Object)this.catalog()).add("EntityType", (Object)this.entityType()).add("FilterList", this.hasFilterList() ? this.filterList() : null).add("Sort", (Object)this.sort()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("OwnershipType", (Object)this.ownershipTypeAsString()).add("EntityTypeFilters", (Object)this.entityTypeFilters()).add("EntityTypeSort", (Object)this.entityTypeSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "FilterList": {
                return Optional.ofNullable(clazz.cast(this.filterList()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "OwnershipType": {
                return Optional.ofNullable(clazz.cast(this.ownershipTypeAsString()));
            }
            case "EntityTypeFilters": {
                return Optional.ofNullable(clazz.cast(this.entityTypeFilters()));
            }
            case "EntityTypeSort": {
                return Optional.ofNullable(clazz.cast(this.entityTypeSort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("FilterList", FILTER_LIST_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("OwnershipType", OWNERSHIP_TYPE_FIELD);
        map.put("EntityTypeFilters", ENTITY_TYPE_FILTERS_FIELD);
        map.put("EntityTypeSort", ENTITY_TYPE_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesRequest, T> g) {
        return obj -> g.apply((ListEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String entityType;
        private List<Filter> filterList = DefaultSdkAutoConstructList.getInstance();
        private Sort sort;
        private String nextToken;
        private Integer maxResults;
        private String ownershipType;
        private EntityTypeFilters entityTypeFilters;
        private EntityTypeSort entityTypeSort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.entityType(model.entityType);
            this.filterList(model.filterList);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.ownershipType(model.ownershipType);
            this.entityTypeFilters(model.entityTypeFilters);
            this.entityTypeSort(model.entityTypeSort);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final List<Filter.Builder> getFilterList() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterList(Collection<Filter.BuilderImpl> filterList) {
            this.filterList = FilterListCopier.copyFromBuilder(filterList);
        }

        @Override
        public final Builder filterList(Collection<Filter> filterList) {
            this.filterList = FilterListCopier.copy(filterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Filter ... filterList) {
            this.filterList(Arrays.asList(filterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Consumer<Filter.Builder> ... filterList) {
            this.filterList(Stream.of(filterList).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Sort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getOwnershipType() {
            return this.ownershipType;
        }

        public final void setOwnershipType(String ownershipType) {
            this.ownershipType = ownershipType;
        }

        @Override
        public final Builder ownershipType(String ownershipType) {
            this.ownershipType = ownershipType;
            return this;
        }

        @Override
        public final Builder ownershipType(OwnershipType ownershipType) {
            this.ownershipType(ownershipType == null ? null : ownershipType.toString());
            return this;
        }

        public final EntityTypeFilters.Builder getEntityTypeFilters() {
            return this.entityTypeFilters != null ? this.entityTypeFilters.toBuilder() : null;
        }

        public final void setEntityTypeFilters(EntityTypeFilters.BuilderImpl entityTypeFilters) {
            this.entityTypeFilters = entityTypeFilters != null ? entityTypeFilters.build() : null;
        }

        @Override
        public final Builder entityTypeFilters(EntityTypeFilters entityTypeFilters) {
            this.entityTypeFilters = entityTypeFilters;
            return this;
        }

        public final EntityTypeSort.Builder getEntityTypeSort() {
            return this.entityTypeSort != null ? this.entityTypeSort.toBuilder() : null;
        }

        public final void setEntityTypeSort(EntityTypeSort.BuilderImpl entityTypeSort) {
            this.entityTypeSort = entityTypeSort != null ? entityTypeSort.build() : null;
        }

        @Override
        public final Builder entityTypeSort(EntityTypeSort entityTypeSort) {
            this.entityTypeSort = entityTypeSort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEntitiesRequest build() {
            return new ListEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesRequest> {
        public Builder catalog(String var1);

        public Builder entityType(String var1);

        public Builder filterList(Collection<Filter> var1);

        public Builder filterList(Filter ... var1);

        public Builder filterList(Consumer<Filter.Builder> ... var1);

        public Builder sort(Sort var1);

        default public Builder sort(Consumer<Sort.Builder> sort) {
            return this.sort((Sort)((Sort.Builder)Sort.builder().applyMutation(sort)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder ownershipType(String var1);

        public Builder ownershipType(OwnershipType var1);

        public Builder entityTypeFilters(EntityTypeFilters var1);

        default public Builder entityTypeFilters(Consumer<EntityTypeFilters.Builder> entityTypeFilters) {
            return this.entityTypeFilters((EntityTypeFilters)((EntityTypeFilters.Builder)EntityTypeFilters.builder().applyMutation(entityTypeFilters)).build());
        }

        public Builder entityTypeSort(EntityTypeSort var1);

        default public Builder entityTypeSort(Consumer<EntityTypeSort.Builder> entityTypeSort) {
            return this.entityTypeSort((EntityTypeSort)((EntityTypeSort.Builder)EntityTypeSort.builder().applyMutation(entityTypeSort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

