/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary;
import software.amazon.awssdk.services.marketplacecatalog.model.EntitySummaryListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesResponse
extends MarketplaceCatalogResponse
implements ToCopyableBuilder<Builder, ListEntitiesResponse> {
    private static final SdkField<List<EntitySummary>> ENTITY_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitySummaryList").getter(ListEntitiesResponse.getter(ListEntitiesResponse::entitySummaryList)).setter(ListEntitiesResponse.setter(Builder::entitySummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitySummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntitiesResponse.getter(ListEntitiesResponse::nextToken)).setter(ListEntitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntitiesResponse.memberNameToFieldInitializer();
    private final List<EntitySummary> entitySummaryList;
    private final String nextToken;

    private ListEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entitySummaryList = builder.entitySummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntitySummaryList() {
        return this.entitySummaryList != null && !(this.entitySummaryList instanceof SdkAutoConstructList);
    }

    public final List<EntitySummary> entitySummaryList() {
        return this.entitySummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitySummaryList() ? this.entitySummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesResponse)) {
            return false;
        }
        ListEntitiesResponse other = (ListEntitiesResponse)((Object)obj);
        return this.hasEntitySummaryList() == other.hasEntitySummaryList() && Objects.equals(this.entitySummaryList(), other.entitySummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesResponse").add("EntitySummaryList", this.hasEntitySummaryList() ? this.entitySummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitySummaryList": {
                return Optional.ofNullable(clazz.cast(this.entitySummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntitySummaryList", ENTITY_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesResponse, T> g) {
        return obj -> g.apply((ListEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogResponse.BuilderImpl
    implements Builder {
        private List<EntitySummary> entitySummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesResponse model) {
            super(model);
            this.entitySummaryList(model.entitySummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<EntitySummary.Builder> getEntitySummaryList() {
            List<EntitySummary.Builder> result = EntitySummaryListCopier.copyToBuilder(this.entitySummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitySummaryList(Collection<EntitySummary.BuilderImpl> entitySummaryList) {
            this.entitySummaryList = EntitySummaryListCopier.copyFromBuilder(entitySummaryList);
        }

        @Override
        public final Builder entitySummaryList(Collection<EntitySummary> entitySummaryList) {
            this.entitySummaryList = EntitySummaryListCopier.copy(entitySummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySummaryList(EntitySummary ... entitySummaryList) {
            this.entitySummaryList(Arrays.asList(entitySummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySummaryList(Consumer<EntitySummary.Builder> ... entitySummaryList) {
            this.entitySummaryList(Stream.of(entitySummaryList).map(c -> (EntitySummary)((EntitySummary.Builder)EntitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntitiesResponse build() {
            return new ListEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesResponse> {
        public Builder entitySummaryList(Collection<EntitySummary> var1);

        public Builder entitySummaryList(EntitySummary ... var1);

        public Builder entitySummaryList(Consumer<EntitySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

