/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.MachineLearningProductEntityIdFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.MachineLearningProductLastModifiedDateFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.MachineLearningProductTitleFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.MachineLearningProductVisibilityFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MachineLearningProductFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MachineLearningProductFilters> {
    private static final SdkField<MachineLearningProductEntityIdFilter> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityId").getter(MachineLearningProductFilters.getter(MachineLearningProductFilters::entityId)).setter(MachineLearningProductFilters.setter(Builder::entityId)).constructor(MachineLearningProductEntityIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<MachineLearningProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(MachineLearningProductFilters.getter(MachineLearningProductFilters::lastModifiedDate)).setter(MachineLearningProductFilters.setter(Builder::lastModifiedDate)).constructor(MachineLearningProductLastModifiedDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<MachineLearningProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductTitle").getter(MachineLearningProductFilters.getter(MachineLearningProductFilters::productTitle)).setter(MachineLearningProductFilters.setter(Builder::productTitle)).constructor(MachineLearningProductTitleFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<MachineLearningProductVisibilityFilter> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visibility").getter(MachineLearningProductFilters.getter(MachineLearningProductFilters::visibility)).setter(MachineLearningProductFilters.setter(Builder::visibility)).constructor(MachineLearningProductVisibilityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, LAST_MODIFIED_DATE_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MachineLearningProductFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MachineLearningProductEntityIdFilter entityId;
    private final MachineLearningProductLastModifiedDateFilter lastModifiedDate;
    private final MachineLearningProductTitleFilter productTitle;
    private final MachineLearningProductVisibilityFilter visibility;

    private MachineLearningProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    public final MachineLearningProductEntityIdFilter entityId() {
        return this.entityId;
    }

    public final MachineLearningProductLastModifiedDateFilter lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final MachineLearningProductTitleFilter productTitle() {
        return this.productTitle;
    }

    public final MachineLearningProductVisibilityFilter visibility() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MachineLearningProductFilters)) {
            return false;
        }
        MachineLearningProductFilters other = (MachineLearningProductFilters)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibility(), other.visibility());
    }

    public final String toString() {
        return ToString.builder((String)"MachineLearningProductFilters").add("EntityId", (Object)this.entityId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibility()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("ProductTitle", PRODUCT_TITLE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MachineLearningProductFilters, T> g) {
        return obj -> g.apply((MachineLearningProductFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MachineLearningProductEntityIdFilter entityId;
        private MachineLearningProductLastModifiedDateFilter lastModifiedDate;
        private MachineLearningProductTitleFilter productTitle;
        private MachineLearningProductVisibilityFilter visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(MachineLearningProductFilters model) {
            this.entityId(model.entityId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
        }

        public final MachineLearningProductEntityIdFilter.Builder getEntityId() {
            return this.entityId != null ? this.entityId.toBuilder() : null;
        }

        public final void setEntityId(MachineLearningProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(MachineLearningProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final MachineLearningProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(MachineLearningProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(MachineLearningProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final MachineLearningProductTitleFilter.Builder getProductTitle() {
            return this.productTitle != null ? this.productTitle.toBuilder() : null;
        }

        public final void setProductTitle(MachineLearningProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(MachineLearningProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final MachineLearningProductVisibilityFilter.Builder getVisibility() {
            return this.visibility != null ? this.visibility.toBuilder() : null;
        }

        public final void setVisibility(MachineLearningProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(MachineLearningProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public MachineLearningProductFilters build() {
            return new MachineLearningProductFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MachineLearningProductFilters> {
        public Builder entityId(MachineLearningProductEntityIdFilter var1);

        default public Builder entityId(Consumer<MachineLearningProductEntityIdFilter.Builder> entityId) {
            return this.entityId((MachineLearningProductEntityIdFilter)((MachineLearningProductEntityIdFilter.Builder)MachineLearningProductEntityIdFilter.builder().applyMutation(entityId)).build());
        }

        public Builder lastModifiedDate(MachineLearningProductLastModifiedDateFilter var1);

        default public Builder lastModifiedDate(Consumer<MachineLearningProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return this.lastModifiedDate((MachineLearningProductLastModifiedDateFilter)((MachineLearningProductLastModifiedDateFilter.Builder)MachineLearningProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate)).build());
        }

        public Builder productTitle(MachineLearningProductTitleFilter var1);

        default public Builder productTitle(Consumer<MachineLearningProductTitleFilter.Builder> productTitle) {
            return this.productTitle((MachineLearningProductTitleFilter)((MachineLearningProductTitleFilter.Builder)MachineLearningProductTitleFilter.builder().applyMutation(productTitle)).build());
        }

        public Builder visibility(MachineLearningProductVisibilityFilter var1);

        default public Builder visibility(Consumer<MachineLearningProductVisibilityFilter.Builder> visibility) {
            return this.visibility((MachineLearningProductVisibilityFilter)((MachineLearningProductVisibilityFilter.Builder)MachineLearningProductVisibilityFilter.builder().applyMutation(visibility)).build());
        }
    }
}

