/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferSetAssociatedOfferIdsListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferSetStateString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfferSetSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OfferSetSummary.getter(OfferSetSummary::name)).setter(OfferSetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(OfferSetSummary.getter(OfferSetSummary::stateAsString)).setter(OfferSetSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseDate").getter(OfferSetSummary.getter(OfferSetSummary::releaseDate)).setter(OfferSetSummary.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_OFFER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedOfferIds").getter(OfferSetSummary.getter(OfferSetSummary::associatedOfferIds)).setter(OfferSetSummary.setter(Builder::associatedOfferIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedOfferIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOLUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionId").getter(OfferSetSummary.getter(OfferSetSummary::solutionId)).setter(OfferSetSummary.setter(Builder::solutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD, RELEASE_DATE_FIELD, ASSOCIATED_OFFER_IDS_FIELD, SOLUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OfferSetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String state;
    private final String releaseDate;
    private final List<String> associatedOfferIds;
    private final String solutionId;

    private OfferSetSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.releaseDate = builder.releaseDate;
        this.associatedOfferIds = builder.associatedOfferIds;
        this.solutionId = builder.solutionId;
    }

    public final String name() {
        return this.name;
    }

    public final OfferSetStateString state() {
        return OfferSetStateString.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String releaseDate() {
        return this.releaseDate;
    }

    public final boolean hasAssociatedOfferIds() {
        return this.associatedOfferIds != null && !(this.associatedOfferIds instanceof SdkAutoConstructList);
    }

    public final List<String> associatedOfferIds() {
        return this.associatedOfferIds;
    }

    public final String solutionId() {
        return this.solutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedOfferIds() ? this.associatedOfferIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferSetSummary)) {
            return false;
        }
        OfferSetSummary other = (OfferSetSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.releaseDate(), other.releaseDate()) && this.hasAssociatedOfferIds() == other.hasAssociatedOfferIds() && Objects.equals(this.associatedOfferIds(), other.associatedOfferIds()) && Objects.equals(this.solutionId(), other.solutionId());
    }

    public final String toString() {
        return ToString.builder((String)"OfferSetSummary").add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("ReleaseDate", (Object)this.releaseDate()).add("AssociatedOfferIds", this.hasAssociatedOfferIds() ? this.associatedOfferIds() : null).add("SolutionId", (Object)this.solutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "AssociatedOfferIds": {
                return Optional.ofNullable(clazz.cast(this.associatedOfferIds()));
            }
            case "SolutionId": {
                return Optional.ofNullable(clazz.cast(this.solutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ReleaseDate", RELEASE_DATE_FIELD);
        map.put("AssociatedOfferIds", ASSOCIATED_OFFER_IDS_FIELD);
        map.put("SolutionId", SOLUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OfferSetSummary, T> g) {
        return obj -> g.apply((OfferSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String state;
        private String releaseDate;
        private List<String> associatedOfferIds = DefaultSdkAutoConstructList.getInstance();
        private String solutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferSetSummary model) {
            this.name(model.name);
            this.state(model.state);
            this.releaseDate(model.releaseDate);
            this.associatedOfferIds(model.associatedOfferIds);
            this.solutionId(model.solutionId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OfferSetStateString state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final Collection<String> getAssociatedOfferIds() {
            if (this.associatedOfferIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedOfferIds;
        }

        public final void setAssociatedOfferIds(Collection<String> associatedOfferIds) {
            this.associatedOfferIds = OfferSetAssociatedOfferIdsListCopier.copy(associatedOfferIds);
        }

        @Override
        public final Builder associatedOfferIds(Collection<String> associatedOfferIds) {
            this.associatedOfferIds = OfferSetAssociatedOfferIdsListCopier.copy(associatedOfferIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedOfferIds(String ... associatedOfferIds) {
            this.associatedOfferIds(Arrays.asList(associatedOfferIds));
            return this;
        }

        public final String getSolutionId() {
            return this.solutionId;
        }

        public final void setSolutionId(String solutionId) {
            this.solutionId = solutionId;
        }

        @Override
        public final Builder solutionId(String solutionId) {
            this.solutionId = solutionId;
            return this;
        }

        public OfferSetSummary build() {
            return new OfferSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfferSetSummary> {
        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(OfferSetStateString var1);

        public Builder releaseDate(String var1);

        public Builder associatedOfferIds(Collection<String> var1);

        public Builder associatedOfferIds(String ... var1);

        public Builder solutionId(String var1);
    }
}

