/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.Change;
import software.amazon.awssdk.services.marketplacecatalog.model.Intent;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.RequestedChangeListCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.Tag;
import software.amazon.awssdk.services.marketplacecatalog.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChangeSetRequest
extends MarketplaceCatalogRequest
implements ToCopyableBuilder<Builder, StartChangeSetRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(StartChangeSetRequest.getter(StartChangeSetRequest::catalog)).setter(StartChangeSetRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<Change>> CHANGE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeSet").getter(StartChangeSetRequest.getter(StartChangeSetRequest::changeSet)).setter(StartChangeSetRequest.setter(Builder::changeSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Change::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(StartChangeSetRequest.getter(StartChangeSetRequest::changeSetName)).setter(StartChangeSetRequest.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartChangeSetRequest.getter(StartChangeSetRequest::clientRequestToken)).setter(StartChangeSetRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> CHANGE_SET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeSetTags").getter(StartChangeSetRequest.getter(StartChangeSetRequest::changeSetTags)).setter(StartChangeSetRequest.setter(Builder::changeSetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Intent").getter(StartChangeSetRequest.getter(StartChangeSetRequest::intentAsString)).setter(StartChangeSetRequest.setter(Builder::intent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CHANGE_SET_FIELD, CHANGE_SET_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHANGE_SET_TAGS_FIELD, INTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartChangeSetRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<Change> changeSet;
    private final String changeSetName;
    private final String clientRequestToken;
    private final List<Tag> changeSetTags;
    private final String intent;

    private StartChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.changeSet = builder.changeSet;
        this.changeSetName = builder.changeSetName;
        this.clientRequestToken = builder.clientRequestToken;
        this.changeSetTags = builder.changeSetTags;
        this.intent = builder.intent;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasChangeSet() {
        return this.changeSet != null && !(this.changeSet instanceof SdkAutoConstructList);
    }

    public final List<Change> changeSet() {
        return this.changeSet;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasChangeSetTags() {
        return this.changeSetTags != null && !(this.changeSetTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> changeSetTags() {
        return this.changeSetTags;
    }

    public final Intent intent() {
        return Intent.fromValue(this.intent);
    }

    public final String intentAsString() {
        return this.intent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeSet() ? this.changeSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeSetTags() ? this.changeSetTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.intentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChangeSetRequest)) {
            return false;
        }
        StartChangeSetRequest other = (StartChangeSetRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasChangeSet() == other.hasChangeSet() && Objects.equals(this.changeSet(), other.changeSet()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasChangeSetTags() == other.hasChangeSetTags() && Objects.equals(this.changeSetTags(), other.changeSetTags()) && Objects.equals(this.intentAsString(), other.intentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartChangeSetRequest").add("Catalog", (Object)this.catalog()).add("ChangeSet", this.hasChangeSet() ? this.changeSet() : null).add("ChangeSetName", (Object)this.changeSetName()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ChangeSetTags", this.hasChangeSetTags() ? this.changeSetTags() : null).add("Intent", (Object)this.intentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ChangeSet": {
                return Optional.ofNullable(clazz.cast(this.changeSet()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ChangeSetTags": {
                return Optional.ofNullable(clazz.cast(this.changeSetTags()));
            }
            case "Intent": {
                return Optional.ofNullable(clazz.cast(this.intentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ChangeSet", CHANGE_SET_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ChangeSetTags", CHANGE_SET_TAGS_FIELD);
        map.put("Intent", INTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartChangeSetRequest, T> g) {
        return obj -> g.apply((StartChangeSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<Change> changeSet = DefaultSdkAutoConstructList.getInstance();
        private String changeSetName;
        private String clientRequestToken;
        private List<Tag> changeSetTags = DefaultSdkAutoConstructList.getInstance();
        private String intent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChangeSetRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.changeSet(model.changeSet);
            this.changeSetName(model.changeSetName);
            this.clientRequestToken(model.clientRequestToken);
            this.changeSetTags(model.changeSetTags);
            this.intent(model.intent);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final List<Change.Builder> getChangeSet() {
            List<Change.Builder> result = RequestedChangeListCopier.copyToBuilder(this.changeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSet(Collection<Change.BuilderImpl> changeSet) {
            this.changeSet = RequestedChangeListCopier.copyFromBuilder(changeSet);
        }

        @Override
        public final Builder changeSet(Collection<Change> changeSet) {
            this.changeSet = RequestedChangeListCopier.copy(changeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Change ... changeSet) {
            this.changeSet(Arrays.asList(changeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Consumer<Change.Builder> ... changeSet) {
            this.changeSet(Stream.of(changeSet).map(c -> (Change)((Change.Builder)Change.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getChangeSetTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.changeSetTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSetTags(Collection<Tag.BuilderImpl> changeSetTags) {
            this.changeSetTags = TagListCopier.copyFromBuilder(changeSetTags);
        }

        @Override
        public final Builder changeSetTags(Collection<Tag> changeSetTags) {
            this.changeSetTags = TagListCopier.copy(changeSetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSetTags(Tag ... changeSetTags) {
            this.changeSetTags(Arrays.asList(changeSetTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSetTags(Consumer<Tag.Builder> ... changeSetTags) {
            this.changeSetTags(Stream.of(changeSetTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIntent() {
            return this.intent;
        }

        public final void setIntent(String intent) {
            this.intent = intent;
        }

        @Override
        public final Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        @Override
        public final Builder intent(Intent intent) {
            this.intent(intent == null ? null : intent.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChangeSetRequest build() {
            return new StartChangeSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartChangeSetRequest> {
        public Builder catalog(String var1);

        public Builder changeSet(Collection<Change> var1);

        public Builder changeSet(Change ... var1);

        public Builder changeSet(Consumer<Change.Builder> ... var1);

        public Builder changeSetName(String var1);

        public Builder clientRequestToken(String var1);

        public Builder changeSetTags(Collection<Tag> var1);

        public Builder changeSetTags(Tag ... var1);

        public Builder changeSetTags(Consumer<Tag.Builder> ... var1);

        public Builder intent(String var1);

        public Builder intent(Intent var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

