/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.GlobalCluster;
import software.amazon.awssdk.services.neptune.model.GlobalClusterListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalClustersResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeGlobalClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeGlobalClustersResponse.getter(DescribeGlobalClustersResponse::marker)).setter(DescribeGlobalClustersResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<GlobalCluster>> GLOBAL_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalClusters").getter(DescribeGlobalClustersResponse.getter(DescribeGlobalClustersResponse::globalClusters)).setter(DescribeGlobalClustersResponse.setter(Builder::globalClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusters").build(), ListTrait.builder().memberLocationName("GlobalClusterMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterMember").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, GLOBAL_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGlobalClustersResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<GlobalCluster> globalClusters;

    private DescribeGlobalClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.globalClusters = builder.globalClusters;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasGlobalClusters() {
        return this.globalClusters != null && !(this.globalClusters instanceof SdkAutoConstructList);
    }

    public final List<GlobalCluster> globalClusters() {
        return this.globalClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalClusters() ? this.globalClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalClustersResponse)) {
            return false;
        }
        DescribeGlobalClustersResponse other = (DescribeGlobalClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasGlobalClusters() == other.hasGlobalClusters() && Objects.equals(this.globalClusters(), other.globalClusters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGlobalClustersResponse").add("Marker", (Object)this.marker()).add("GlobalClusters", this.hasGlobalClusters() ? this.globalClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "GlobalClusters": {
                return Optional.ofNullable(clazz.cast(this.globalClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("GlobalClusters", GLOBAL_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalClustersResponse, T> g) {
        return obj -> g.apply((DescribeGlobalClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<GlobalCluster> globalClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalClustersResponse model) {
            super(model);
            this.marker(model.marker);
            this.globalClusters(model.globalClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<GlobalCluster.Builder> getGlobalClusters() {
            List<GlobalCluster.Builder> result = GlobalClusterListCopier.copyToBuilder(this.globalClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalClusters(Collection<GlobalCluster.BuilderImpl> globalClusters) {
            this.globalClusters = GlobalClusterListCopier.copyFromBuilder(globalClusters);
        }

        @Override
        public final Builder globalClusters(Collection<GlobalCluster> globalClusters) {
            this.globalClusters = GlobalClusterListCopier.copy(globalClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusters(GlobalCluster ... globalClusters) {
            this.globalClusters(Arrays.asList(globalClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusters(Consumer<GlobalCluster.Builder> ... globalClusters) {
            this.globalClusters(Stream.of(globalClusters).map(c -> (GlobalCluster)((GlobalCluster.Builder)GlobalCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeGlobalClustersResponse build() {
            return new DescribeGlobalClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalClustersResponse> {
        public Builder marker(String var1);

        public Builder globalClusters(Collection<GlobalCluster> var1);

        public Builder globalClusters(GlobalCluster ... var1);

        public Builder globalClusters(Consumer<GlobalCluster.Builder> ... var1);
    }
}

