/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChangeType {
    CORE_NETWORK_SEGMENT("CORE_NETWORK_SEGMENT"),
    NETWORK_FUNCTION_GROUP("NETWORK_FUNCTION_GROUP"),
    CORE_NETWORK_EDGE("CORE_NETWORK_EDGE"),
    ATTACHMENT_MAPPING("ATTACHMENT_MAPPING"),
    ATTACHMENT_ROUTE_PROPAGATION("ATTACHMENT_ROUTE_PROPAGATION"),
    ATTACHMENT_ROUTE_STATIC("ATTACHMENT_ROUTE_STATIC"),
    ROUTING_POLICY("ROUTING_POLICY"),
    ROUTING_POLICY_SEGMENT_ASSOCIATION("ROUTING_POLICY_SEGMENT_ASSOCIATION"),
    ROUTING_POLICY_EDGE_ASSOCIATION("ROUTING_POLICY_EDGE_ASSOCIATION"),
    ROUTING_POLICY_ATTACHMENT_ASSOCIATION("ROUTING_POLICY_ATTACHMENT_ASSOCIATION"),
    CORE_NETWORK_CONFIGURATION("CORE_NETWORK_CONFIGURATION"),
    SEGMENTS_CONFIGURATION("SEGMENTS_CONFIGURATION"),
    SEGMENT_ACTIONS_CONFIGURATION("SEGMENT_ACTIONS_CONFIGURATION"),
    ATTACHMENT_POLICIES_CONFIGURATION("ATTACHMENT_POLICIES_CONFIGURATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChangeType> VALUE_MAP;
    private final String value;

    private ChangeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeType> knownValues() {
        EnumSet<ChangeType> knownValues = EnumSet.allOf(ChangeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChangeType.class, ChangeType::toString);
    }
}

