/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CoreNetworkState {
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CoreNetworkState> VALUE_MAP;
    private final String value;

    private CoreNetworkState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CoreNetworkState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CoreNetworkState> knownValues() {
        EnumSet<CoreNetworkState> knownValues = EnumSet.allOf(CoreNetworkState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CoreNetworkState.class, CoreNetworkState::toString);
    }
}

