/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoreNetworkChangeSetResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetCoreNetworkChangeSetResponse> {
    private static final SdkField<List<CoreNetworkChange>> CORE_NETWORK_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CoreNetworkChanges").getter(GetCoreNetworkChangeSetResponse.getter(GetCoreNetworkChangeSetResponse::coreNetworkChanges)).setter(GetCoreNetworkChangeSetResponse.setter(Builder::coreNetworkChanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkChanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoreNetworkChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCoreNetworkChangeSetResponse.getter(GetCoreNetworkChangeSetResponse::nextToken)).setter(GetCoreNetworkChangeSetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_CHANGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCoreNetworkChangeSetResponse.memberNameToFieldInitializer();
    private final List<CoreNetworkChange> coreNetworkChanges;
    private final String nextToken;

    private GetCoreNetworkChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworkChanges = builder.coreNetworkChanges;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCoreNetworkChanges() {
        return this.coreNetworkChanges != null && !(this.coreNetworkChanges instanceof SdkAutoConstructList);
    }

    public final List<CoreNetworkChange> coreNetworkChanges() {
        return this.coreNetworkChanges;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoreNetworkChanges() ? this.coreNetworkChanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreNetworkChangeSetResponse)) {
            return false;
        }
        GetCoreNetworkChangeSetResponse other = (GetCoreNetworkChangeSetResponse)((Object)obj);
        return this.hasCoreNetworkChanges() == other.hasCoreNetworkChanges() && Objects.equals(this.coreNetworkChanges(), other.coreNetworkChanges()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCoreNetworkChangeSetResponse").add("CoreNetworkChanges", this.hasCoreNetworkChanges() ? this.coreNetworkChanges() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkChanges": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkChanges()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CoreNetworkChanges", CORE_NETWORK_CHANGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCoreNetworkChangeSetResponse, T> g) {
        return obj -> g.apply((GetCoreNetworkChangeSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<CoreNetworkChange> coreNetworkChanges = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreNetworkChangeSetResponse model) {
            super(model);
            this.coreNetworkChanges(model.coreNetworkChanges);
            this.nextToken(model.nextToken);
        }

        public final List<CoreNetworkChange.Builder> getCoreNetworkChanges() {
            List<CoreNetworkChange.Builder> result = CoreNetworkChangeListCopier.copyToBuilder(this.coreNetworkChanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoreNetworkChanges(Collection<CoreNetworkChange.BuilderImpl> coreNetworkChanges) {
            this.coreNetworkChanges = CoreNetworkChangeListCopier.copyFromBuilder(coreNetworkChanges);
        }

        @Override
        public final Builder coreNetworkChanges(Collection<CoreNetworkChange> coreNetworkChanges) {
            this.coreNetworkChanges = CoreNetworkChangeListCopier.copy(coreNetworkChanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworkChanges(CoreNetworkChange ... coreNetworkChanges) {
            this.coreNetworkChanges(Arrays.asList(coreNetworkChanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworkChanges(Consumer<CoreNetworkChange.Builder> ... coreNetworkChanges) {
            this.coreNetworkChanges(Stream.of(coreNetworkChanges).map(c -> (CoreNetworkChange)((CoreNetworkChange.Builder)CoreNetworkChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCoreNetworkChangeSetResponse build() {
            return new GetCoreNetworkChangeSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoreNetworkChangeSetResponse> {
        public Builder coreNetworkChanges(Collection<CoreNetworkChange> var1);

        public Builder coreNetworkChanges(CoreNetworkChange ... var1);

        public Builder coreNetworkChanges(Consumer<CoreNetworkChange.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

