/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Sequence").getter(PathComponent.getter(PathComponent::sequence)).setter(PathComponent.setter(Builder::sequence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sequence").build()}).build();
    private static final SdkField<NetworkResourceSummary> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resource").getter(PathComponent.getter(PathComponent::resource)).setter(PathComponent.setter(Builder::resource)).constructor(NetworkResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(PathComponent.getter(PathComponent::destinationCidrBlock)).setter(PathComponent.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_FIELD, RESOURCE_FIELD, DESTINATION_CIDR_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PathComponent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer sequence;
    private final NetworkResourceSummary resource;
    private final String destinationCidrBlock;

    private PathComponent(BuilderImpl builder) {
        this.sequence = builder.sequence;
        this.resource = builder.resource;
        this.destinationCidrBlock = builder.destinationCidrBlock;
    }

    public final Integer sequence() {
        return this.sequence;
    }

    public final NetworkResourceSummary resource() {
        return this.resource;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequence());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent)obj;
        return Objects.equals(this.sequence(), other.sequence()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"PathComponent").add("Sequence", (Object)this.sequence()).add("Resource", (Object)this.resource()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sequence": {
                return Optional.ofNullable(clazz.cast(this.sequence()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sequence", SEQUENCE_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer sequence;
        private NetworkResourceSummary resource;
        private String destinationCidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            this.sequence(model.sequence);
            this.resource(model.resource);
            this.destinationCidrBlock(model.destinationCidrBlock);
        }

        public final Integer getSequence() {
            return this.sequence;
        }

        public final void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        @Override
        public final Builder sequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public final NetworkResourceSummary.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(NetworkResourceSummary.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(NetworkResourceSummary resource) {
            this.resource = resource;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public PathComponent build() {
            return new PathComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathComponent> {
        public Builder sequence(Integer var1);

        public Builder resource(NetworkResourceSummary var1);

        default public Builder resource(Consumer<NetworkResourceSummary.Builder> resource) {
            return this.resource((NetworkResourceSummary)((NetworkResourceSummary.Builder)NetworkResourceSummary.builder().applyMutation(resource)).build());
        }

        public Builder destinationCidrBlock(String var1);
    }
}

